The long goodbye to Microsoft Windows XP Embedded
There are those that get work done early, those that get it done on time, and those that procrastinate until every task is an emergency. Those still using Microsoft Windows XP Embedded in their industrial environments will fall into the latter category because Microsoft’s extended support for Windows XP Embedded ends on January 12, 2016. The 15-year-old operating system will no longer be supported or updated, no matter how much users clamor or beg.
Companies still using Microsoft Windows XP Embedded systems in their facilities will be running into several additional risks. For example, it will be difficult to find compatible hardware and software, and it will be difficult, if not impossible, to get updates to the applications currently running, which will make the systems more vulnerable. If there are Microsoft Windows XP systems running and they can’t be replaced, then take measures to reduce potential risks. What is worse is to not even know if you have any XP systems running.
It is vital to complete a software and IT hardware inventory of the entire facility, which includes far more than just the production systems. It is important to also consider your laboratory systems, maintenance systems, warehouse systems, tank farm systems, HVAC systems, physical security systems, document management systems, planning systems, and development systems. Without a complete inventory, "hidden" systems under employee’s desks, which are performing critical functions, might go unnoticed. For example, is the scheduling department still using a XP-based tool, or worse: a DOS-based tool; is the laboratory using XP-based test equipment; are the automated material movement systems running XP-based configuration and maintenance software; or is the security department using an XP-based badge scanning system?
At the very minimum, a complete system inventory will make it clear if there’s a potential support problem. In this situation, as said in children’s cartoons, "Now you know, and knowing is half the battle." With a complete inventory, the next steps in the process are much simpler.
First, categorize the systems’ support availability using the following criteria:
- Active—The system is using the most current automation product offering by the vendor.
- Mature—The system is using a fully supported and available product, but a more current product is available.
- End of Life—The system is using a product that has a future end of support date from the vendor.
- Discontinued—The system is using a product that is no longer available for support by the vendor, and replacements and support are only available from third-party suppliers.
- Obsolete—The system is using a product where support and replacements are no longer available.
Next, categorize the systems based on their risk to production:
- High—The system has a direct impact on product quality and is critical to site operations.
- Medium—The system has an indirect impact on product quality and is critical to site operations.
- Low—The system has an indirect impact on product quality and is not critical to site operations.
- None—The system has no direct or indirect impact on product quality and no direct impact on site operations.
Combining these into a criticality matrix can help determine the priority for system replacement as shown below.
The worst situation is to have high risk and obsolete systems where there are no readily available replacements.
In these situations, the first step is to virtualize the hardware, which at least removes the risk of a hardware failure and provides backups in case of software failures. Second, the systems should be isolated from other networks through demilitarized zones (DMZs), firewalls, or physical separation. It is likely the Microsoft Windows XP system will be running vulnerable browsers, databases, applications, and drivers, which makes isolation even more vital. However, virtualization and isolation are only temporary fixes to give the manager time to implement long-term solutions.
Determining whether the XP-based system has been compromised is difficult. One way to test is to use the virtual machine environment to create a "canary" copy to test the security. Finally, you can apply the same method used to handle the loss of Windows NT support following the "I AM FEARLESS" approach: Isolate, Apply Major patches, Fix, Enhance, Abandon, or Retire Legacy Shop floor Systems.
With extended support now over for Microsoft Windows XP Embedded and no major patches available, the term to remember is now "I FEAR"—Isolate, Fix, Enhance, Abandon, or Retire. This is an appropriate feeling for those still running mission critical systems on Microsoft Windows XP.
– Dennis Brandl is president of BR&L Consulting in Cary, N.C. His firm focuses on manufacturing IT. Edited by Chris Vavra, production editor, CFE Media, Control Engineering, cvavra@cfemedia.com.
ONLINE extra
– See related articles by Brandl below, which discuss using a canary to test security as well as the loss of Microsoft Windows NT support.
Want this article on your website? Click here to sign up for a free account in ContentStream® and make that happen.