Critical to our ability to survive and thrive for generations to come is ongoing access to adequate supplies of clean, fresh water. For the foreseeable future, significant freshwater withdrawals will be needed for irrigation, thermal power plant cooling, and myriad industrial and residential uses. But in many regions, socioeconomic and environmental pressures pose growing threats to both the quantity and quality of local water resources. In order to take effective action to mitigate and/or adapt to rising risks, decision-makers will need robust, prediction-based strategies and tools.
Toward that end, the MIT Joint Program on the Science and Policy of Global Change convened a workshop “Water Resource Risks: Integrated Approaches to Support Actions,” on December 6 on the MIT campus. Drawing 40 in-person and online participants (primarily program sponsors), the gathering was the first of the Joint Program’s new workshop series on leading-edge, actionable global change research. Presentations and discussions highlighted recent and ongoing Joint Program research on water resource risk management and explored opportunities for program researchers and sponsors to work together.
“As scientists, we’re inspired by discovery-driven research that may not have a direct impact on our everyday lives, but our industrial sponsors have a strong pulse on what research can really make a difference now to critical decisions,” said Joint Program Deputy Director Adam Schlosser, who organized the workshop. “My hope is that we can bring together the discovery-driven inspirations of the scientific community and the delivery-driven, applied research goals of our sponsors, find common areas of interest, and emerge with salient projects on which we can collaborate.”
Computational tools to manage water risk under uncertainty
Morning sessions focused on how to move from models to predictions to decisions about water resources under uncertainty.
Joint Program Research Scientist Kenneth Strzepek described the evolution of global water models over the past century, and the utility and limits of today’s models. Strzepek noted that while the computational sophistication of global water models has improved dramatically, their projections still come with a significant degree of uncertainty. Reducing that uncertainty to levels that permit meaningful decision-making entails modeling water resource system behavior at the appropriate scale and resolution to address the research question at hand. For example, to assess the physical and economic impact of climate change on managed water-resource systems, the Joint Program combines its MIT Integrated Global System Modeling (IGSM) framework with a water resource system (WRS) component that enables analyses at the scale of river basins.
Schlosser explored factors that limit the precision of hydrologic model-based predictions, and how to use predictions effectively to project water resource risk. He identified three main constraints on the accuracy of a prediction about a water resource system: sensitivity of the prediction to the initial state of the system, to external forces acting on the system (such as temperature and precipitation in the case of hydrologic models), and to the scale at which data is collected. Citing Joint Program research on projecting the frequency of extreme precipitation events in U.S. regions in the 21st century, he stressed the need to model a sufficiently large sample of plausible outcomes in order to obtain actionable information.
Sarah Fletcher, a PhD student at the MIT Institute for Data, Systems and Society, presented a flexible infrastructure design framework that she’s developed to enable economical decision-making for water storage systems under uncertainty. Citing research she pursued under Strzepek’s supervision, Fletcher showed how her framework could have significantly reduced costs of building a reservoir system to protect Melbourne’s water supply from drought. Rather than designing a robust but expensive system to cover worst-case scenarios, her flexible, adaptive approach provides guidance for the design of a modular system in which storage capacity can be added as conditions evolve.
Assessing risk at the water-energy-food nexus
Afternoon sessions examined four relevant research focus areas: water stress, water quality, water for energy, and water for agriculture.
Joint Program Research Scientist Xiang Gao explored different measures of water stress, or the degree to which water supply from runoff, groundwater and other local sources is inadequate to meet demand from industrial, agricultural, domestic and other sectors. Gao emphasized the need for risk-based assessment of water scarcity that incorporates probabilistic representation of different sources of uncertainty, and that accounts for regions’ vulnerability to reduced water supplies and ability to respond.
Joint Program Research Affiliate Brent Boehlert, a senior associate at Industrial Economics, Inc., presented results on the impact of climate change on water quality in the U.S. in the 21st century. His findings indicate a likely decline in water quality that could be slowed by climate mitigation measures and more sustainable farming practices. Boehlert cited a study that he co-authored by Strzepek and others that projects significant algal blooms in the U.S. Northeast and Midwest due to global warming.
Strzepek examined the water requirements of thermoelectric, hydroelectric and solar power, and water-use tradeoffs involved in meeting food, water and energy demands. Noting that water withdrawals will vary depending on greenhouse gas emissions levels, he observed that less water will be needed for thermoelectric cooling under a low-emissions scenario that promotes greater use of renewable energy technologies. Strzepek described his efforts to combine water, energy and crop models to enable decision-makers to analyze energy/food tradeoffs in Africa under different emissions scenarios.
Joint Program Principal Research Scientist Niven Winchester shared findings from his research on assessing the impact of changing water availability on agriculture. Noting that global food demand, climate change and climate policies favoring bioenergy production are expected to increase pressures on water resources in many regions around the world, Winchester has developed methods to represent additional irrigable land in 126 river basins in a combined IGSM-WRS model. Using the model, he has assessed the costs of expanding production in these areas through upgrades such as improving irrigation efficiency and increasing water storage.
Schlosser highlighted several examples of the use of models to help decision-makers develop mitigation or adaptation policies to prepare for projected changes in the water-energy-food nexus. Citing a study in which he and co-author Gao projected the relative impacts of socioeconomic growth and climate change on water stress levels in China and India by mid-century, Schlosser showed that socioeconomic growth will inevitably increase water stress, with climate change playing a minor role. He suggested that the more economical way for these countries to manage water risk is to adapt. One possible adaptation measure is to improve irrigation efficiency by lining canals and/or using high-efficiency sprinklers.
Finally, participants shared their ideas for research and investment opportunities. Suggestions for future projects included projecting and mapping global water risks by 2050 under an unconstrained emissions scenario as well as under Paris Agreement commitments, developing tools to determine the timing of significant changes in regional water risk, producing baseline projections for water risk in agriculturally-intensive regions under different climate scenarios, and incorporating water-quality models to improve the reliability of water-availability projections.