In previous blog article on simulation in collaborative environment, we introduced SIMULIA 3D Experience platform and discussed the concept behind its inception, the reason why it exists in the industry and briefly discussed its four integrated components: 3D modeling, information intelligence, social & collaboration and simulation. All four of these collectively form 3D Compass. This blog article explains the configuration of simulation component in more detail.
In general, 3D Experience platform uses few specific terms with respect to its configuration: Personas, Roles, Apps and Extensions. These terms primarily govern how various platform functionalities are bundled, licensed and made available to users.
Personas: Defines the job responsibilities of a group of users. Every user has at-least one persona. Configuration requires estimation of number of personas and number of users in each persona.
Roles: Based on job activities, each persona has to be mapped with a specific role. The platform offers a library of different roles. Each role is a bundle of sellable license features or apps.
Apps: An app can be defined as a group of functionalities to achieve a specific task. For example, a fluid model creation app offers multiple GUI features to define fluid model such a fluid domain creation, fluid mesh, boundary layer mesh, fluid material definition etc.
Extensions: These are a bundle of top-up apps that can be added to a given role to enhance its overall functionality.
Role Categories
Remember that in case of standalone point solutions, we discussed two broad categories: designer level solutions that are primarily CAD embedded vs. expert level solutions with their own graphical user interfaces and complex workflows. In 3D Experience platform as well, Simulation roles can be differentiated into engineer roles and analyst roles. There is also a third category of roles called as process roles. Each of these types of roles require some basic platform roles as pre-requisites.
Extensions vs. Roles
Each extension can be ideally treated as a mini role. Extension, if compatible with a given role can be added to it to enhance its functionality without duplicating any app available in the role. Here is an example for demonstration.
Mechanical Analyst and FEM Specialist are roles with number of apps as shown above. Now if an SMU user needs SIMULIA model assembly design app, there are two ways to do it. An expensive approach would be to procure entire SFM role that would not only increase cost substantially but would also duplicate apps common between SMU and SFM. An economical approach is to add the SMA extension with only relevant app to the SMU role.
Simulation capacity: Tokens vs credits
A token is a governor of maximum amount of simulation that can run concurrently. More tokens mean more concurrent simulation. A token is a renewable simulation resource. Once simulation is complete, tokens are returned to the token license pool. Jobs can be submitted either on premise or on cloud. Both these options have different token categories.
A credit is a consumable computation resource that is not replenished once the simulation is complete. There is no limit on how fast a credit may be consumed during concurrent simulation. The user procures compute credits that gets consumed as simulation progresses. The rate of credit consumption is directly related to speed of simulation. Quite often, analysts prefer to use tokens as one-time investment. The credits are used to meet occasional peak demand when tokens are not enough to meet simulation capacity needed.
In future blog articles related to 3D Experience platform, we will discuss various roles available for stress analysis as well as their underlying apps, extensions and simulation capacity.