Quebec's Autorité des marchés financiers ("AMF") recently turned its attention to motor vehicle replacement insurance distributors and damage insurance firms. Specifically, it took two steps:
- It issued a Notice on February 16, 2015, setting out a number of practices that are non-compliant with either or both of two Quebec statutes: An Act respecting insurance and An Act respecting the distribution of financial products and services, commonly known as the "Financial Products Act".
- At the same time, the AMF fined nine motor vehicle dealers and one damage insurance firm for engaging in such practices. The AMF's news release, which contains a link to the English version of the Notice, is available here.
Background
This is not the first time that the AMF has provided guidance on motor vehicle replacement insurance and condemned improper practices. In 2010, an AMF Notice (in French only) set out the AMF's view on motor vehicle replacement warranties ("GAP warranties"), classifying them as insurance products that may be sold only by a licensed firm or through the distribution regime of the Financial Products Act. Various other AMF notices on motor vehicle insurance were published in 2009, 2010 and 2012.
How the Financial Products Act regulates the sale of damage insurance
Under the Financial Products Act, damage insurance (including motor vehicle replacement insurance) may be sold in Quebec in either of two ways:
- Through a licensed damage insurance representative/firm; or
- Through the distribution regime, which permits certain non-licensed businesses, such as motor vehicle dealers, to sell certain types of motor vehicle insurance directly.
As the AMF emphasizes in the Notice of February 16, 2015, the distribution regime imposes obligations on insurers and distributors. Pursuant to this regime, the insurer must:
- Provide the distributor with an approved distribution guide;
- Ensure that the distributor is familiar with the insurance product;
- Set up mechanisms to ensure that the distribution activities comply with the Quebec legal and regulatory framework; and
- Refrain from providing incentives that may affect the distributor's fair treatment of consumers.
The notice reminds insurers of the legal provisions and guidelines applicable to them which impose these obligations. The distributors also have various obligations under the Financial Products Act, including distributing the guide to the consumer purchasing the insurance and ensuring the consumer is properly informed about the product.
Non-compliant practices singled out in the Notice
Pursuant to the Notice, current non-compliant practices of motor vehicle dealers include:
- Failing to notify customers when the commissions received exceed 30% of the insurance premium;
- Failing to offer customers of replacement insurance two options in the event of a loss, i.e. (i) the replacement of the vehicle through the designated dealer or (ii) an indemnity so the consumer can have his or her vehicle replaced through the dealer of his or her choice;
- Adding the balance of a previous debt to the purchase price of the vehicle indicated in the replacement insurance contract (QPF No. 5);
- Comparing replacement insurance with the replacement cost endorsement, an activity that constitutes advice and which therefore may only be performed by certified insurance representatives;
- Offering automobile insurance products covering civil liability and damage to the vehicle (QPF No. 1), a product that may only be offered by damage insurance agents and brokers registered with the AMF (including gathering personal information in order to obtain a quote in this regard);
- Failing to provide a copy of the distribution guide to the customer prior to the sale of the insurance product;
- Making financing or a lower financing rate conditional on the customer's purchase of replacement insurance;
- Compelling a customer to have his or her vehicle repaired with a specific dealer in the event of a partial loss;
- Selling replacement insurance offered to customers who already hold a replacement cost endorsement or advising the customer to replace the endorsement with the insurance.
Finally, the damage insurance representative/firm must not:
- Intentionally not propose the replacement cost endorsement when selling QPF No. 1 in order that the distributor can instead sell the customers replacement insurance.
The AMF's "final word"
The AMF concludes the Notice with the stern warning that it "intends to take the necessary measures to put an end to any practice that is not in compliance with the Insurance Act and theDistribution Act", adding that it "may impose an administrative sanction or take penal proceedings against any person who fails to comply with these Acts [and] may also order an insurer to cease distributing an insurance product through distributors."