Since South Korean President Moon Jae-in took office in 2017 – after Park Geun-hye was impeached from the presidency for several charges, including bribery and abuse of power – the Moon administration has taken a radically different stance on historical conflicts with Japan.
In 2015, under Park’s administration, South Korea reached a deal with Japan to compensate South Korean “comfort women,” the euphemistic term for women who were forced to sexually service the Japanese military during World War II. Seoul’s foreign minister, as well as Ban Ki-moon, the former U.N. secretary-general, touted the Park administration’s efforts to make the deal with Japan at the time. However, the agreement has ultimately broken down since Moon took office, as he made clear that he would not keep the agreement once he became president. The agreement was never popular among the South Korean public, largely because the comfort women victims themselves had not been consulted during the negotiation process.
Since then, Tokyo has explicitly condemned the Moon government’s efforts to overturn the comfort women agreement, concluding that Moon has no interest in cooperating with Japan. However, Moon has expressed his willingness to improve ties with Japan since he took office, by suggesting that the two countries can pursue a “two-track” approach to separately handle historical disputes and cooperation on common interests that could strengthen relations.
Lee Jae-myung, the presidential candidate of the ruling Democratic Party, once said that he is not “an anti-Japanese” politician after some Japanese media introduced him as hawkish toward Japan. Ultimately, his stance on Japan is no different from Moon’s. Lee has made clear that he would seek to improve relations with Japan – as Moon has repeatedly said – but pointed out that such improvement can only take place when Japan shows a different approach to historical issues. Lee has particularly urged Japan to change its stance on the territorial dispute over Dokdo, which Tokyo calls Takeshima.
Lee has also called for South Korea to do more to punish pro-Japanese Koreans who had cooperated with the Japanese military to inform on the Korean Independence Army and suppress their activities during the Japanese military rule from 1910 to 1945. In this context, Lee emphasized the necessity of investigating and documenting the pro-Japanese activities of all chief officers who served at government agencies, not only during the colonial period but throughout the Republic of Korea’s history, up until today.
Yoon Seok-youl, the presidential candidate of the conservative People Power Party, however, has shown a different perspective on Japan. Yoon once told reporters that it is time to improve relations with Japan through a “future-oriented” perspective, adding that Moon completely destroyed Japan-South Korea relations. Yoon cited the “Kim-Obuchi declaration,” a joint declaration issued by former South Korean President Kim Dae-jung and former Japanese Prime Minister Obuchi Keizo in 1998, as an example to show his will to improve relations with Japan. As the PPP’s party leader has promised to negotiate with Japan more actively than Moon, Yoon seems trying to make room for future negotiations with Japan should he become the president.
However, Lee countered that Yoon has a lack of understanding on the Kim-Obuchi joint declaration, which was based on the Japanese leader’s sincere apologies and willingness to take full responsibility for historical conflicts to move forward.
Experts in Seoul predict that it would be challenging for South Korea to seek ways to improve ties with Japan, regardless of who wins the presidential election next year. With Japan under the leadership of the Liberal Democratic Party, which takes a hawkish stance on the historical disputes, it seems impossible for Seoul to convince Tokyo to make a sincere apology directly to comfort women and forced laborers, much less to take legal responsibility to solve the issue.
“I think making sincere apologies to Seoul by taking a forward-looking stance on the historical disputes is off Tokyo’s table,” Nam Ki-jeong, a professor of Japanese studies at Seoul National University, told The Diplomat.
The Moon administration has urged a two-track approach, which would separate out historical issues while finding momentum to cooperate with Japan on shared interests of the day, including North Korea’s nuclear and missile threats and the challenge of China’s rise. However, after several court rulings awarding compensation to Korean forced laborers, Japan is urging South Korea to handle the historical disputes first if it wants to improve ties.
Park Ji-won, director of South Korea’s National Intelligence Service, last year proposed that then-Japanese Prime Minister Suga Yoshihide make a joint declaration in a similar format to the Kim-Obuchi declaration in a bid to improve relations. According to media reports at the time, Suga refused to accept the proposal due to the two countries’ disputes over historical conflicts.
The presidential election next year will naturally impact Seoul’s Japan policy, “as the two major parties have different overtures and policies on North Korea on the basis of ‘nationalism,” Nam said. “The relationships Moon and Park formed with North Korea and Japan are different. Therefore, it is important for the next government to reconcile these two important issues in a balanced manner.”
Meanwhile, the vice foreign ministers of South Korea, the United States, and Japan held a meeting on Wednesday in Washington, D.C. to discuss regional issues, including North Korea. The representatives said they had a productive meeting and were satisfied with the results. However, they failed to hold a joint press conference due to Japan’s complaint over the South Korean commissioner of the National Police Agency’s visit to Dokdo on Tuesday during the meeting, according to Choi Jong-kun, Seoul’s first vice foreign minister. Choi added that the commissioner’s visit was not on the official agenda to discuss.