How to determine how much you need
Auto Insurance and Liability Coverage
by Gary Foreman
Dear Dollar Stretcher,
We just bought a new car and are trying to determine what level of auto insurance we need. The big argument my husband and I are having is over the values for Bodily Injury. There appear to be 3 levels of coverage which are fairly standard: $100K / $300K, $50K / $100K and $25K / $50K. The first number is per person, the second is per incident. As I understand it, our assets should come into play in determining which level to buy. Well, we don't own a home and my best guess is approximately $100K. Do you have any advice for us?
Amy S.
Amy asks a good question. It's the kind of question that not only can save us some cash, but tell us a lot about our feelings toward money. Let's look at the question from two different perspectives. First, just considering the purely financial aspects. Then, we'll look at some other considerations that could effect her decision.
The financial aspects are pretty straight forward. In fact, Amy has outlined them already. You'll be quoted two numbers for each level of insurance. The first number is the maximum that the insurance company will pay to any one person. The second number represents the total amount that they will pay to anyone involved in one accident on your behalf. So, in the event of an accident, the $100K / $300K quote would pay up to $100,000 to one person or $300,000 to everyone hurt in an accident.
Let's avoid one area of confusion. Amy's question doesn't specifically define 'bodily injury' insurance. There are two types. The first is the damage that we cause others in an accident that's partially or totally your fault. The second is the medical bills that you or your passengers have because of an accident.
While states are generally similar in what is included in each type of insurance, you'll need to talk with your agent. That's not ducking the question. Regardless of where you live you need to protect against certain losses. You need to be able to cover bills for yourself, your passengers and other people that are hurt because you were driving your car. Claims can be due to medical expenses, loss of wages, property damage, pain and suffering, and other similar bills.
If an accident occurs, you don't really care about legal definitions. You just want the bills to be paid. The way to protect yourself is to make sure that you have coverage for all of the circumstances described.
Back to Amy's question. She's been told that her assets should influence her decision about how much insurance to buy. And it's definitely something to consider. Let's look at an illustration to see why that's true. Suppose she picks the lowest level of insurance ($25K / $50K) and has an accident that causes the other driver to win a judgment of $75,000 against Amy. Her insurance company would write a check for $25,000 and Amy would need to write one for $50,000. Unless they're an unusual family, Amy and her husband are unlikely to have that much money and might need years to pay off that large a debt.
That's where the assets come in. Some people will tell you to carry at least as much insurance as the value of your assets. If Amy had carried $100K / $300K on our example, the insurance company would have paid the entire settlement. So far, so good.
But what happens if Amy has an accident with a judgment of $150,000? What will happen then? The insurance company will pay the first $100,000. That leaves $50,000 for Amy to pay. In that situation many people will consider declaring bankruptcy. Here's where it gets a little tricky. Each state has it's own bankruptcy laws. Most are fairly generous in allowing debtors to keep personal possessions. But do you want to depend on that?
Which brings us to the more subjective part of the question. Should the amount of money you could owe be the only concern? Suppose a toddler wandered out into the street and you hit and crippled the child. The bills would easily exceed $100,000. Is it fair to the child's family for you to declare bankruptcy and leave them with the bills? You'll need to answer that one for yourself, but it is something to think about.
One way to protect yourself from very large claims is to purchase a personal liability umbrella policy. It pays for claims that are above the limits of your auto policy and typically run to about $1.5 million. They're not prohibitively expensive. A call to your agent can get you the actual cost.
On a side note, I wouldn't be surprised if a number of you are thinking that many of these large settlements are fraudulent and shouldn't be paid. And you're right. Many claims are faked. Just recently I saw some statistics from the National Insurance Crime Bureau that suggested that fraud adds up to $300 to our insurance bills each year. And, like you, I want to see that stopped. But that doesn't mean that drivers shouldn't carry proper insurance coverage.
A final thought about auto insurance. None of us likes to pay for car insurance. But your liability coverages probably isn't the place to look for savings. Should something bad happen, the failure to have enough insurance could mean declaring bankruptcy. If you need to cut your insurance bill, consider raising your deductible. If you raise your deductible from $500 to $1,000 the very worst thing that can happen is that you have to pay a $1,000 auto repair bill. You might not like it, but you should be able to avoid financial collapse!
Thanks to Amy for asking a fascinating question. We hope her family enjoys that new car and never finds the need to make a claim on that insurance!
Reviewed December 2017
Take the Next Step
- Are you a homeowner? Find out how to reduce homeowners insurance costs along with your auto insurance.
- Do you have an auto loan? Determine if you need GAP insurance.
- Use this handy cheat sheet from a 30-year veteran of the auto insurance industry to get the best auto insurance deal that you can.
- Get control of your financial life. Subscribe to Financial Independence, a free daily email that provides you with the tools to help you gain that control and achieve financial independence. Subscribers get a copy of Are You Heading for Debt Trouble? A Simple Checklist for FREE!
>.