Nostalgia has a way of smoothing out the rough edges of things we loved, and that’s certainly true of retro gaming. Those games could be brutally difficult, with iffy controls, indecipherable graphics, and a complete lack of direction as to what the player was supposed to do. Even some of the best 8-bit games have issues like that. It’s incredibly unfair that when you lose your last life in World 8 of Super Mario Bros., you have to start over at the first level. You could spend hours wandering around in The Legend of Zelda without knowing you needed to find a dungeon. Castlevania made you write down passwords, for cryin’ out loud. A lot of core features that make up retro games feel like vestigial tails when compared to today’s games. The technology got better. We moved past those problems.
So how, in this age of immediate respawns and autosaves, tutorials and on-screen objectives, do we go back to the 8-bit world? And why would we want to?
Alwa’s Awakening might hold some answers.
A 2-D adventure platformer from Elden Pixels, Alwa’s Awakening is a purposeful hearkening back the glory days of the NES in both graphics and gameplay. The game it most immediately brought to mind was Zelda II: The Adventure of Link, particularly in the town sections, but you can find bits of Castlevania and Metroid and a whole host of other classics in its DNA. It’s bound together by a light story about a girl summoned to a faraway land (Alwa) to fight evil, collect magical objects, and solve environmental puzzles so specific to her skills that it’s a wonder any of the NPCs manage to get around in Alwa at all.
I started Alwa’s Awakening feeling ambivalent, although there were a lot of positives right off the bat. The 8-bit graphics are masterful, gorgeously giving each area in Alwa a strong sense of place. The chiptune score adds to the mood and is a perfect salute to the beloved NES soundtracks of yore. The controls aren’t as tight as they’d be in a modern platformer, but they’re pleasantly floaty and work well with the tasks required of you. (When I died, it was never because of the controls). It doesn’t feel like it moves as fast as a lot of other retro-inspired modern titles, like Shovel Knight, but that’s a good thing. It’s more focused on the adventure/puzzle aspect than it is on super-quick, rock ‘em sock ‘em action, so the slower pace lends itself well to pondering what to do in a room before you do it.
Here’s where we get to the negative I encountered early on
I am so, so bad at this game. I’ve grown soft playing games with detailed maps and an ever-present guide giving you hints. The areas in Alma flow directly into one another, which could make it hard to get my bearings. Characters don’t give you clear directions to your next location; instead, it’s a vague “east of here.” And not, like, two screens east. Many, many screens East. Where you sometimes have to double back to reach previously unreachable areas. I spent a lot of time cluelessly wandering around.
My other major source of frustration was that Alwa’s Awakening relies on save points. Interestingly, you keep items that you got after you last saved when you respawn, which led to me occasionally kamikaze-ing myself at an item even when I knew I was going to get killed by the enemy guarding it. But that one helpful feature doesn’t make up for the seemingly endless treks from the save point through three other rooms before getting to the room where I misjudged my jump and got hit with a fireball again.
As I said, I was getting frustrated, and it was not making me feel fondly about the game.
Slowly, though, something started happening.
I sat back and took a deep breath before I entered a difficult room, no matter how many times I had already tried it. I felt a tremendous sense of joy when I finally got through a room I had died in seven times before. I upgraded my magic staff to create items that helped me solve puzzles, and I became giddy at my own cleverness for solving them. I started to enjoy exploring the world with no particular goal in mind, just wondering what might be over this next bridge. Times when I would have tilted out for dying instead became experiments from which I learned more about how the world of Alwa works.
It was . . . freeing. I didn’t know all the answers, and it didn’t matter because of the fun and sense of accomplishment I felt as I was bungling along.
Perhaps the biggest difference between gaming now and gaming then is the time crunch we all live in. There is always so much to do, and never enough time to do it in. You will never get to see every great movie you want to see, read every good book you’re sure you would like, play every awesome video game, especially when they’re spread across at six-ish current-gen platforms.
I think that’s what was bothering me about playing Alwa’s Awakening. I didn’t have time to redo that jumping sequence ten times. I didn’t want to waste time walking around that could have been spent advancing in the game. But what I came to realize was that I wasn’t wasting time. There was value in the moments I was confused. There was value in taking my time to soak in the atmosphere of the game. There was value in trying and failing and trying again.
I had known that when I was a little kid watching my sisters play The Legend of Zelda. I’d forgotten it along the way.
The OPN Interview with Robert Kreese and Alex Berggren
The Verdict
So that’s the importance of a retro game, and Alwa’s Awakening demonstrates it beautifully..