Oct 22, 2021
Winter crisis raises prospect of energy blockades in Europe
Bloomberg News,
Increased U.S. exports and a cold winter could cause a crisis for natural gas: Schneider Electric's Redmond.
“If it gets very cold, even within Europe you will see countries say: ‘I have the gas inside my borders and I am going to pass an urgent safety measure that no one can export for the next two weeks’,” said Marco Alvera, chief executive officer of Italian energy-infrastructure company Snam SpA. “I have been threatened in several countries over the last 20 years. Political priority is to keep your constituency.”
The European Union’s gas tanks are around 77 per cent full. That is way below what’s normal for this time of year and leaves members especially vulnerable if the winter is severe.
Here’s a look at what it would take for European politicians to flick the switches off and which countries are the most vulnerable.
ARE GOVERNMENTS THREATENING TO BLOCK EXPORTS?
While no government in Europe has yet said they will halt exports, the risk increases the higher energy prices get.
In Norway, one of Europe’s biggest energy exporters, power prices have shot up seven-fold since last year. The leader of Center Party, which may soon be part of a coalition government, said he was assessing whether it’s legal to cut sales to the EU. Serbia might ban electricity exports to ensure that “people have warm homes,” President Aleksandar Vucic said this month. And France threatened to curb power to the U.K.’s Channel Islands amid a dispute over fishing waters.
More than once this winter, the Irish grid operator has shut interconnectors that send wind power to mainland Britain. Ireland has said its shortages are so severe that it could be at risk of blackouts.
WHO'S VULNERABLE?
Outside supplies account for about 80 per cent of the gas the EU consumes, most of it coming from Russia, Norway and Algeria.
Some of the bloc’s biggest economies are among the most exposed. Germany imports 90 per cent of its needs. Countries such as the U.K., Belgium, Spain and Portugal face the added problem of low gas-storage capacity, according to Fabrizio Farina, an analyst at consultant Verisk Maplecroft.
The continent’s got a mass of pipelines and many of them cross several borders, creating plenty of possible choke points. Some of the biggest are Yamal, which goes from Russia through Belarus and Poland before reaching Germany, and TAG, which takes Russian gas to Austria and Italy.
The continent’s electricity network is also increasingly inter-connected. While that was meant to allow for the pooling of resources and to build an integrated energy market, it could leave some countries vulnerable to shut-offs.
HOW CAN COUNTRIES BLOCK EXPORTS?
The EU has so-called ‘solidarity principles’ that are supposed to prevent any state blocking exports of power or gas and leaving another member short, especially when it comes to supplies for households.
“As tempting as it may be, EU member states will not be able to choke gas supplies to struggling neighbors if they are to follow EU regulations,” said Farina.
The system, however, has never been tested in an energy crisis.
“In practice, it will be bloody hard,” said Thierry Bros, a former energy trader who’s now a professor at the Paris Institute of Political Studies. “Member states will start to argue. Germany faces the worst risk of disruption this winter because it uses a lot of energy and its storage is quite empty. I don’t think the Spanish, the French, the Polish will be very happy to help them.”
Grid operators claim that they’re allowed to stop or alter power flows through inter-country cables if they lack enough electricity for their own network. Or the decision could come from governments.
“When faced with a genuine crisis and the prospect of power outages, it’s entirely feasible that politicians could decide to suspend exports to protect their electorates,” said Benjamin Collie, a principal at Aurora Energy Research Ltd. “For this to happen, we would need to see simultaneous supply crunches in multiple interconnected markets.”
Another scenario is that energy isn’t blocked, but is instead diverted from poorer countries to richer ones, such as Germany, that can cope with higher prices.
“That is more likely than an active shut-off,” said Antony Froggat, a researcher at Chatham House in London.
WHAT'S THE DOWNSIDE TO FLICKING THE SWITCH?
Any country stopping flows would forgo export revenues and transit fees. The financial losses could be hefty. But governments might think they’re worth it when compared to the political fallout if their own citizens can’t keep their lights and heaters on.
DOES BREXIT MAKE A DIFFERENCE?
The U.K’s exit from the EU means it no longer has to adhere to the solidarity principles. That makes it easier, legally, for London to reduce energy exports to the bloc. Yet the country is a net importer and gets much of its gas and power from the EU.
“Brexit puts the U.K. at higher risk of being stranded if EU countries use energy as a bargaining tool or experience severe shortages this winter,” said Farina.