Quota sampling is a type of non-probability sampling technique. Non-probability sampling focuses on sampling techniques that are based on the judgement of the researcher [see our article Non-probability sampling to learn more about non-probability sampling]. This article explains (a) what quota sampling is, (b) how to create a quota sample, and (c) the advantages and disadvantages (limitations) of quota sampling.
Imagine that a researcher wants to understand more about the career goals of students at the University of Bath. Let's say that the university has roughly 10,000 students. These 10,000 students are our population (N). In order to understand more about this population, we only need to examine a sample (n) of students, not the whole population of 10,000 students. Furthermore, sometimes we are interested in particular strata (groups) within the population. Therefore, the quota sample involves dividing the population into two or more strata (groups). These strata are expressed as H.
For example, imagine we were interested in comparing the differences in career goals between male and female students at the University of Bath. If this was the case, we would want to ensure that the sample we selected had a proportional number of male and female students relative to the population. Therefore, the total number of male and female students included in our quota would only be equal if 5,000 students from the university were male and the other 5,000 students were female. Since this is unlikely to be the case, the number of units that should be selected for each stratum (that is, the number of male and female students selected) will vary. We explain how this is achieved in the next section: Creating a quota sample.
To create a quota sample, there are three steps: (a) choosing the relevant stratification and dividing the population accordingly; (b) calculating a quota for each stratum; and (c) continuing to invite cases until the quota for each stratum is met.
If we wanted to look at the differences in male and female students, this would mean choosing gender as the stratification, but it could similarly involve choosing students from different subjects (e.g., social sciences, medicine, engineering, education, etc.), year groups, or some other variable(s).
The number of cases that should be included in each stratum will vary depending on the make-up of each stratum within the population. If we were to examine the differences in male and female students, for example, the number of students from each group that we would include in the sample would be based on the proportion of male and female students amongst the 10,000 university students. For example, if there were 6,000 male students (60% of the total) and 4,000 female students (40% of the total), our sample would need to be made up of 60% males and 40% females. If our desired sample size was 100 students, this would mean our sample should include 60 male students and 40 female students.
Once you have selected the number of cases you need in each stratum, you simply need to keep inviting participants to take part in your research until each of these quotas are filled.
Quota sampling is particularly useful when you are unable to obtain a probability sample, but you are still trying to create a sample that is as representative as possible of the population being studied. In this respect, it is the non-probability based equivalent of the stratified random sample.
Unlike probability sampling techniques, especially stratified random sampling, quota sampling is much quicker and easier to carry out because it does not require a sampling frame and the strict use of random sampling techniques. This makes it popular in undergraduate and master's level dissertations where there is a need to divide the population being studied into strata (groups).
The quota sample improves the representation of particular strata (groups) within the population, as well as ensuring that these strata are not over-represented. For example, it would ensure that we have sufficient male students taking part in the research (60% of our sample size of 100; hence, 60 male students). It would also make sure we did not have more than 60 male students, which would result in an over-representation of male students in our research.
The use of a quota sample, which leads to the stratification of a sample (e.g., male and female students), allows us to more easily compare these groups (strata).isation.
It must be possible to clearly divide the population into strata; that is, each unit from the population must only belong to one stratum. In our example, this would be fairly simple, since our strata are male and female students. Clearly, a student could only be classified as either male or female. No student could fit into both categories (ignoring transgender issues).
Furthermore, imagine extending the sampling requirements such that we were also interested in how career goals changed depending on whether a student was an undergraduate or graduate. Since the strata must be mutually exclusive, this means that we would need to sample four strata from the population: undergraduate males, undergraduate females, graduate males, and graduate females. This will increase overall sample size required for the research, which can increase costs and time to carry out the research.