Perhaps the most common type of discrimination claim that employers face is disparate treatment. Disparate impact and disparate treatment are two legal theories of discrimination, and it’s critically important that you protect yourself and your business from these kinds of actions. Good intentions are not enough to defend yourself in these claims, which are all about results. Take time to go through all your hiring practices and employment procedures to identify any possible vulnerabilities, and think about the way each policy is implemented. If an action of disparate treatment or disparate impact is ever brought against you, get an attorney involved.
Disparate Treatment
Disparate treatment is a claim of intentional employment discrimination based upon an individual’s membership in a protected class. The claim is that a specific employee or candidate belonging to a protected class was singled out and unfairly treated in a job-related action, with “discriminatory intent or motive.” This focus on intent is particular to disparate treatment; the plaintiff must prove, using either direct evidence (such as an admission that the decision was motivated by discrimination), or, more commonly, circumstantial evidence. This might include suspicious behavior toward members of the group, which can be used to build a pattern of discriminatory intent; examples of comparable employees not in the protected class getting better treatment; or evidence that the plaintiff was more qualified than the person who ultimately got the position, who is not a member of the protected class.
Disparate Impact
Unlike disparate treatment, a disparate impact claim of discrimination is not interested in discriminatory intent; it only looks at discriminatory outcomes. The foundation of disparate impact is a policy that is intended to be neutral and non-discriminatory, but when used in practice it disproportionately affects members of a protected class. Disparate impact is usually defined by statistical measurements of how a policy affects members of particular groups at a substantially higher rate than members of other groups. Disparate impact is not illegal on its own; what makes it illegal is when the policy in question is unrelated to success in the position. The classic example is in policies requiring firefighters to meet certain strength requirements. The strength requirements disproportionately affect female applicants. So long as the strength requirement is at a level that measures actual requirements of being a firefighter, though, the policy is not illegal. It only becomes illegal if the requirement is lifted above and beyond the requirements one would need to be an effective firefighter. Be aware, disparate impact requires no intention to discriminate; the same company policies are applied to everyone, but still negatively impact one or more groups unfairly.
Protected Classes
These discrimination claims are based upon membership in a protected class. The following are protected classes covered by these theories, as defined by the Civil Rights Act of 1964:
- Race
- Color
- Religion
- National Origin
- Gender
- Age
- Familial Status
- Disability
- Veteran Status
- Genetic Information
These classes are protected at the federal level, while other classes have protection in certain jurisdictions but not in others. Find out if there are any additional protected classes in your area.