What.
Why Reader’s Theater?
When using scripts written for the classroom like those in the Integrated Skills Through Drama series, the advantages of doing a script as Reader’s Theater are:
- Learners experience both language and communication strategies in conversational contexts. They are able to feel the language from the inside and reflect on how expressions, words and phrases are used to attain conversational goals.
- Pronunciation and intonation work is purpose-driven as actors work to communicate the emotional intention of their characters
- The script is already prepared, giving students a language experience that can be practiced and then adapted to other contexts.
- There’s no need for props, sets, costumes, or even a stage making it easier and quicker to produce.
- A Reader’s Theater performance supports success by allowing actors to refer to a script. This saves time, which can be spent on ancillary skills work or even discussion of the themes of the play.
Considerations
As written above, Reader’s Theater can be as simple as putting students in a circle, assigning parts, and having them read a script. However, it can be a lot more involved than that as well. Here are some considerations and decisions to make:
- A play is a story that reflects human experience and can thus lend itself to rich discussion. Spend some time talking about the story. Have students listen to the play and/or read the script first and talk about the message. Share experiences and insights into the world of the play.
- Also consider working on the characters motivations. After students are assigned roles, have them work out the back story of the character by answering Wh- questions. Who is the character? Where did they grow up? What are they good at? or where do they struggle in life? Importantly, what do they want? How are they trying to get what they want? This can help with the pronunciation/intonation work and how they use their voice.
- Decide how much practice time to give. A good rule of thumb is students should be able to look up from the script half the time. Aaron Shepherd refers to this as “half-memorizing.” And to let students think about what intonation, rhythm, word stress, and volume they will use for each line, they’ll need time to read and mark up the script. For example, students may want to:
- Add descriptions of action
- Add lines
- Practice motion
- Note emotions and intonations
- Highlight their part
- Another helpful preparation activity is to use the characters and contexts to do role plays. Students can borrow language from the script and adapt it for new purposes.
- As you prepare for a performance, you may want a narrator who can describe the scene and the setting. The narrator can even describe the action of the play if you do not want students to move or act out the action of the play. This may require writing in a narrator part or expanding an existing narrator’s lines.
- Decide if the students will move while they read or remain stationary. If they will be stationary, will they sit or stand. And who will sit where? Often in Reader’s Theater, major characters are positioned in the middle while narrators sit on the ends.
- If you want the students to move, decide how much they will move and how much of the action will they act out. This is called blocking. As noted above, if the readers are not going to be doing much acting with their bodies, the narrators will need to describe the action.
- Because in Reader’s Theater, the students are on stage at all times, you need a way to show which actors are not acting in a particular scene. Students can turn their backs on the audience or look down, for example.
- You may want students to have small props, particularly if the prop is important to the story. For example, a character who is always fiddling with their phone might hold an actual phone even if other props are omitted. If you aren’t using props at all, give students time to work out how they will mime using certain objects or doing certain actions.
- Consider how students will hold the scripts if they are moving. Will they hold in one hand? How often will they need to look down and read? Are there any long speeches?
- If there are scenes with specific settings, such as sitting in a car or speaking to someone who is up on a balcony, you might want to think about how to suggest that setting. For a scene in a car, students could pull two seats forward in front of two other seats. For a balcony scene, one student could stand on a chair or the other students could squat on the floor, for example.
Performing Reader’s Theater
Students can read for each other or for an audience from another class.
You can break the class into two halves, have them read to each other, and then discuss where they made different choices.
Because theatre is inherently dynamic, each cast will produce a unique production.
Extending Reader’s Theater
Reader’s Theater can be the culmination of the study of any piece of literature. After analyzing and reading the story, you can make a Reader’s Theater performance a kind of final celebration or showcase of the student’s understanding of the text.
Reader’s Theater can also be a prelude to a full performance. It can be a part of the rehearsal process in fact. Many performances of plays, TV shows, and films start with what’s called a table read where the actors read the script for the first time sitting around a table. They make notes of how they might read their parts as well as what parts of the script might need rewriting or adapting.
In fact, consider inviting actors to adapt scenes or add new scenes to reflect their changing understanding of the story. Perhaps they can improvise with situations that they want to explore. Ask what if questions, put the characters in new combinations, send them back in time or forward to see where decisions are likely to lead. In this way, Reader’s Theater offers a way to take language from the page and move it into the real world.
One Reply to “How to Do Reader’s Theater”