An investigation into the human, social, environmental and health costs of platinum mining in South Africa
This project was made possible through the support of the Open Society for South Africa (OSF-SA)
Spanning several years of research and groundwork, my initial exploration of the mining sector in South Africa culminated in a body of work between 2011 and 2013 examining the minerals that have directly shaped South Africa’s socio-economic landscape..
The potential for expanding this project soon revealed itself – beyond the peripheries of the city, and into the small towns and rural communities surrounding areas of both abandoned and ongoing mineral activity. Entering these spaces with little pre-existing knowledge allowed me to explore these enormous, enduring socio-economic cleavages through engaging with those most affected – and, generally, most marginal. It is important to emphasise that the inspiration for choosing my subjects and the spaces in which I work is not statistical or scientific data. Rather, it is the product of personal experience; of my own ongoing investigation into, and knowledge gained through my travels across, the diverse and varied landscapes directly impacted by mining.
South Africa has been associated with mineral wealth, both in terms of diversity and abundance, for more than a century. In recent years, the demand for platinum in particular, of which South Africa holds the majority of the world’s reserves, has grown exponentially. But South Africa’s platinum mining industry has also attracted attention for all the wrong reasons. The tragic events that unfolded between 11th and 16th August 2012 at Anglo Platinum’s Lonmin Mine in Marikana in the North West Province resulted in the deaths of 44 people, 34 of whom were protesting miners gunned down by the South African police. A further 70 people were injured, and approximately 250 people arrested in the aftermath. These events sent shockwaves not just throughout South Africa but across the world, drawing international condemnation, igniting global discussion on, and questioning of, mining practices locally and abroad, and leading to a national commission of inquiry that lasted 300 days.
With the support of a grant from the Open Society Foundation for South Africa, I returned to the north of the country in early 2016 with the aim of building on previous projects concerned with transparency and accountability in South Africa’s extractive sector, and to raise further awareness of the wide-ranging impact of platinum mining. The photographic narrative that resulted constitutes an in-depth investigation into the human, social, environmental, economic and health costs of platinum mining, documenting the communities that have grown among and straddle the northern, eastern and western limbs that make up the “platinum belt” or “Bushveld Complex”..
Worldwide, demand for platinum is increasing, driven mainly by its use in catalytic converters in car exhausts and in the jewellery industry. Platinum has also become an important component in some of the new emerging technologies. other area in the world.
But as important as platinum continues to be as a driver of economic growth in South Africa, the human cost has been extraordinary. All across the platinum belt, as the mining companies seek out the mineral in huge open cast mines, the communities that live in their path are forcibly displaced, and often thrust into a completely unsustainable situation, with insufficient land to live on and none of the employment opportunities they were promised.
The mining industry is a microcosm of the overall picture in South Africa, which has enjoyed moderate economic growth while the divisions of the past – between rich and poor, white and black, remain entrenched. The environmental and social costs of mining are considerable, and the benefits that the mines bring are not always equitably shared, while local communities closest to the source of the mineral development suffer the most. Communities that come to depend on the mines for economic survival after having their subsistence farming literally taken from under their feet are especially vulnerable. Their fate forcibly tied to that of the mine, a mine closure spells instant disaster..