- Medicine Information and Evidence for Policy > Medicines Policy
- Traditional Medicine > Traditional, Complementary and Herbal Medicine
(2002; 70 pages) [French] [Spanish]
2.3 Safety, efficacy, quality
Allopathic medicine is based on Western culture. Practitioners therefore emphasize its scientific approach, and contend that it is both value-free and unmarked by cultural values. TM/CAM therapies have developed rather differently, having been very much influenced by the culture and historical conditions within which they first evolved..
... improved."49
This more complex approach to health care makes TM/CAM very attractive to many. But it also makes evaluation highly difficult since so many factors must be taken into account. And since TM/CAM practices have developed within different cultures in different regions, there has been no parallel development of standards and methods - either national or international - for undertaking evaluation. Moreover, CAM providers may come from a cultural and philosophical background that differs radically from that surrounding the original development of a therapy. This can lead to problems of interpretation and application. Understandably, therefore, allopathic medicine practitioners in some countries have been reluctant to refer patients to CAM providers. (This in turn has made health insurance schemes unwilling to reimburse CAM treatments, effectively reducing patients' choice of health care.)
Evaluation of TM/CAM products, such as herbal medicines, is especially difficult. Accuracy of plant identification is essential, as is isolation of active ingredients. The latter is complex, though, because medicinal plant properties are influenced by the time of plant collection and area of plant origin (including environmental conditions). At the same time, a single medicinal plant can contain hundreds of natural constituents. Establishing which constituent is responsible for what effect can therefore be prohibitively expensive. Yet given the worldwide popularity of herbal medicines, a widely applicable, appropriate and effective means of evaluating herbal medicines with limited resources is urgently needed.
Research, research methodology and cost-effectiveness
It is perhaps not surprising that reviews have shown that clinical trials have been few, small and inadequately controlled. The Cochrane Complementary Field (see Chapter 4) found that articles indexed as "alternative medicine" formed only 0.4% of the total number of MEDLINE-listed articles for the period 1966 - 1996. (However, the annual total was steadily increasing during this period and the growing proportion of reports of randomized clinical trials (RCTs) suggested a trend towards an evidence-based medicine approach.) Only some of the RCTs reported included costs (incurred for the therapy in question, and including cost of consultation, materials used, etc.). In fact, very few reliable and full economic analyses of TM/CAM have been made.
Figure 11. Good evidence of efficacy exists for some herbal medicines - but too often evaluation is inadequate
Source: based on data in Herbal Medicines: an Evidence-based Look. Therapeutics Letter, Issue 25, June - July 1998.
The failure to support research in this area over recent years has resulted in a lack of data and development of methodology for evaluating the safety, efficacy and quality of TM/CAM. Yet there are indications that at least some commonly used alternative therapies - for instance, some herbal medicines, manipulative therapies and behavioural stress-reduction techniques, such as transcendental meditation - can provide effective management for chronic disease (Box 2). Box 3 indicates some of the more detailed cost-effective analysis that is beginning to be undertaken. More firm evidence along these lines would be of enormous assistance in presenting arguments for greater recognition and application of TM/CAM. Indeed, it will be a prerequisite if access to TM/CAM is to be promoted and extended, and rational use of this type of health care ensured.
Ensuring safety and quality at national level
Low levels of research activity have also slowed development of national standards for ensuring the safety and quality of TM/CAM therapies and products. In particular, lack of technical guidance and information has hindered development of regulation and registration for herbal medicines. This in turn has slowed development of, for example, national surveillance systems for monitoring and evaluating adverse events. The fact that only 3% of 771 cases of counterfeit drugs reported to WHO by April 1997 involved herbal medicines might be a reflection of this low level of monitoring, rather than an indication that adverse effects from herbal medicines are few.52
Table 8. Key needs in ensuring the safety, efficacy and quality of TM/CAM
Determining research needs
The 6th report from the Committee on Science and Technology to the House of Lords cites a number of problems relating to CAM research in the United Kingdom. They can be taken as applying to research problems in the field in general. The Committee found a poor research infrastructure and concluded that research is often of poor quality because research ethics are not well understood, sound methodology is lacking, resources are in short supply and researchers are unwilling to evaluate evidence. A summary of key needs in ensuring the safety, efficacy and quality of TM/CAM is given in Table 8.
Some priority areas for research are outlined in Table 9.
Table 9. Priority areas for research
Source: House of Lords, 2000.16