Difference between revisions of "Virtual Screening SOP"
From Rizzo_Lab
Latest revision as of 13:03, 16 June 2021
Introduction
We devised a Standard Operating Procedure (SOP) to streamline and remove possible human errors from the process. After running your Virtual Screening experiments and following the protocol at our GitHub repository, you will schedule a meeting with Dr. Rizzo and your collaborators to pick compounds; only then you should pay close attention to the steps below.
Preparing data for the supplier and dealing with quotes
- Prepare a spreadsheet containing the SMILES and ZINC IDs.
- The supplier only needs the SMILES strings; the ZINC ID is there for our own sake.
- Send the supplier an email with a spreadsheet containing the SMILES and the ZINC IDs.
- Be careful with SMILES of nitro-, sulfone-, sulfoxide-, sulfonamide-, phosphate-containing molecules. If MOE generated the SMILES, they could have strange forms that the software used by the supplier does not recognize.
- Be sure to generate two SMILES sets with different software to guarantee that the supplier will not have any issues. Make sure stereochemistry is not lost.
- Tell the supplier to make a quote addressed to:
Professor Robert C. Rizzo Institute of Chemical Biology and Drug Discovery Department of Applied Mathematics and Statistics Math Tower Room 1-111 Stony Brook University Stony Brook NY, 11794-3600
- After you receive a quote back from the supplier, create the directory
zzz.${PDB_CODE}_supplier/and save the spreadsheet with the quote as
${YEAR}_${MONTH}_${DAY}_${SUPPLIER}_quote.xlsx.
- Bring the quote to Dr. Rizzo and discuss the purchase. We usually purchase 3 vials of 5mg of each selected compound, but your needs might be different.
- Access WolfMart. Check this link to find instructions on how to make a purchase using WolfMart.
- We usually purchase molecules from MolPort. However, depending on how the Virtual Screening library was built, you might need to deal with different vendors.
- The supplier needs to send you a spreadsheet containing the well assignments, supplier IDs, lead time, delivery format, SMILES, catalog numbers, etc. If you do not have such a spreadsheet, request one from the supplier. Save the spreadsheet in
zzz.${PDB_CODE}_supplier/as
${YEAR}_${MONTH}_${DAY}_${SUPPLIER}_order_${ORDER_NUMBER}.xlsx.
- Request all spectrometric data, preferably LC/MS and NMR spectra, for the purchased compounds. Create
zzz.${PDB_CODE}_supplier/spectrometric_dataand save there all the experimental data provided by the supplier.
- Sometimes, the supplier will send spectra as
.WMFfiles. You can convert them to PDFs on online servers.
Dealing with samples, spreadsheets and experimental data
- When the compounds arrive, open the boxes and verify molecules one by one. The order of the wells must be the same as the order in the order spreadsheet provided by the supplier.
- PEER-CHECK: Dr. Rizzo will assign another grad student or postdoc to repeat the same procedure to avoid errors. Share the spreadsheet with your colleague.
- This step is mandatory.
- After you receive the spreadsheet from the supplier, create a multi-molecule
.mol2file in the same order as the spreadsheet given by the supplier along with the boxes. The spreadsheet can be generated by a Python script found in our repository.
- Name the
.mol2file as
${YEAR}_${MONTH}_${DAY}_${PDB_CODE}_${SUPPLIER}_picked.mol2.
- The spreadsheet created will be named
${YEAR}_${MONTH}_${DAY}_${PDB_CODE}_${SUPPLIER}_picked.xlsx.
- Extract the descriptors and scores data from the
.mol2file using the Python script mentioned above. Everything will be in a
.csvfile.
- Remembering that the compound order must be preserved, add the descriptor and the information provided by the supplier to
${YEAR}_${MONTH}_${DAY}_${PDB_CODE}_${SUPPLIER}_picked.xlsx.
- Save your work in
zzz.${PDB_CODE}_supplier/and create a backup
.tarfile by:
tar -cvf zzz.${PDB_CODE}_supplier.tar zzz.${PDB_CODE}_supplier
- Send a copy of the
.tarfile to Dr. Rizzo.