Say it with me: Discriminatory segmentation is very much alive today and we need to do something about it, folks! (Insert a bunch of those emphasis clapping emojis.)
While we’re only talking about the overlap between audience segmentation and discrimination in social media advertising here today, this practice is very broad and has been around for a long time. (Probably forever.) Audience discrimination is present in every industry. And while it’s not acceptable in any sector, we are going to narrow our focus and evaluate its impact in social media marketing, specifically as it relates to our work, and how those in our field can move toward positive change today.
It’s not news that, historically, many brands deliberately excluded demographics they didn’t want associated with their products. Similar to the way in which redlining was used as a method for (literal) gatekeeping to refuse people of certain races from obtaining mortgages, brands use audience targeting to manipulate who can obtain their products or services. Especially in mid-20th century America, many brands in the luxury goods and financial services industries (and, let’s be honest, probably a bunch of other industries) specifically targeted only white consumers as they were “worried [targeting non-white consumers] would cheapen or denigrate the value of their products in the marketplace with white consumers.” Of course, this still happens today. It’s just sneakier. (Akin to the news that’s going around now about Louis Vuitton sending Gucci purses to Snooki from Jersey Shore. Sneaky.)
Before Facebook changed its targeting options in 2019, it had a controversial targeting option that was literally called “target by exclusion.” (They weren’t even trying to euphemize that one.) A 2016 ProPublica investigation found that Facebook advertisers could (and did) create housing ads that allowed posters to exclude Black people. Somehow, it took three years for this to culminate into actual change. In March 2019, the Department of Housing and Urban Development sued Facebook for violations of the Fair Housing Act, in allowing advertisers to segment audiences by age, income, gender, and other factors for housing ads. This later expanded to include ads relating to jobs and financial services as well. As a result, Facebook no longer allows advertisers to target any ads based on age, gender, or zip code.
And if you’re wondering how tight these requirements are, wonder no more: We tested it. Multiple times. Unintentionally. After attempting to run an ad broadly referencing housing to people in certain zip codes (cities in comparable population size to the one we were advertising, AKA where we thought audiences would be most likely to be converted), we were required to remove all audience targeting before the ad could run. I can confirm that Facebook now has many, many hoops that advertisers need to jump through before they can run an ad even briefly alluding to housing, jobs, or financial services. Which is a good thing! Inclusivity win!
But this also got me thinking: The murky, grey overlap between audience segmentation and discrimination must extend beyond these three areas. In our own work, how can we ensure our targeting is used for good, instead of perpetuating centuries of blatant discrimination that set the foundation for inequities that are still going strong today?
Look, this question isn’t anything new. Scholars, marketers, and activists have been scratching their heads about this for decades. Studies have been conducted. Conversations have been had. Tweets have been tweeted. The long-short of it, from what I’ve researched? Well – and don’t roll your eyes when I say it – it’s complicated. And it comes back to definitions.
According to our friends at Oxford, the definition of “discriminatory” is: “making or showing an unfair or prejudicial distinction between different categories of people or things, especially on the grounds of race, age, or sex.” To me, it seems like the key part here is “unfair or prejudicial.” That’s what separates your everyday, run-of-the-mill audience targeting and downright discrimination. Are you segmenting your audience todeliberately exclude certain groups based on prejudice? If so, that’s a sign that you should reevaluate your audience segments and the perceived purpose behind them. (And maybe reevaluate your moral compass.)
One great way to know that you’re on the right side of history is if you use audience segmentation as a way to include marginalized groups, rather than exclude them. This means reaching out to (and representing in your advertising) groups that historically have fallen between the cracks when it comes to representation in marketing and advertising. When you compare your existing demographics with your target audience, always ask: Who are we missing? For example: A study from the Association of National Advertisers found that, while Hispanic Americans make up 18.1% of the national population, only 3.6% of advertising spend is targeted at them. I’m just gonna say it: That’s racist, folks. When it comes to including marginalized populations in our audience segments, marketers can always do better.
The distinction between segmentation and discrimination is very murky. And complicated. And this observation isn’t going to solve it with a clean-cut answer. But the bright side is that, from what I’ve seen, it looks like the conversation regarding inclusive and ethical audience targeting is just getting started, and positive changes are being made.
My three rules of thumb when I’m checking those elusive audience targeting options in Facebook Ads Manager? Expand your network to include untapped marginalized groups. Always ask “why?” and understand your purpose when defining audience segments. And, if you think it might be discrimination, well, it probably is.