From rogue ice storms to mind-blowing visualizations of outer space, visual effects artist Jon Parker (B.F.A. Painting ’00) has helped bring to life both real and imagined stories for the past 18 years.
A New York City resident, Parker has created animations for Hayden Planetarium shows at American Museum of Natural History (AMNH) and worked behind the scenes on television commercials for Toys “R” Us, Gillette, and M&Ms. He’s also contributed to a number of feature films including “Sky Captain and the World of Tomorrow” (2004), “Salt” (2010), “The Secret Life of Walter Mitty” (2013), and “Everest” (2015).
To discover what led Parker to this career path, read the following Q&A as we discuss how his Herron training came into play and the skills needed for visual effects and animation work at the professional level.
HERRON: What exactly does your job entail as a freelance computer graphics (“CG&”) generalist?
JON PARKER: There is a continuum of skills possessed by people who work in animation, which ranges from the very technical to the purely creative and intuitive. I often end up in more general roles where I help “glue” both sides of the production together. That could mean knowing how to instruct a programmer to help the team achieve a certain visual look, or helping the creative crew work more efficiently and fixing some of their technical workflow problems.
HERRON: Tell us a little about your computer art background. Did you start exploring the discipline before, during, or after attending Herron?
PARKER: Sometime around 1990 or 1991 I saw a video playing at RadioShack called “The Mind’s Eye: A Computer Animation Odyssey.” I became obsessed with it. Around the same time, I was exploring pre-Internet online bulletin board systems and I discovered some free programs that let me program and create my own computer images.
Later in high school, I convinced my art teacher to allow me to submit some of my images as homework assignments. She really didn’t know what to make of it; nobody had ever created anything in her class like that before. When I entered Herron, there were no classes yet that taught computer animation, so I focused on fine art and traditional skills.
HERRON: How did you begin a career in this field after you graduated?
PARKER: I got a break early on. When I was 19, my dad knew someone who knew about a company creating “graphics” that was then called Phillips Design Group, owned by Greg and Gary Phillips. (Greg is now an owner of Plow Digital in Indianapolis.) I got the company’s address and one day showed up there with a 3.5-inch floppy disk with a few images I’d made in my free time. Somehow that worked and I ended up working for them through most of my time at Herron. By the time I graduated, I already had a small but professional portfolio of CG work.
HERRON: You’ve worked with AMNH on their planetarium shows since 2008. How did you get connected with the museum as a 3D visualizer, animator, CG supervisor, and lead technical director?
PARKER: A producer from another company I had freelanced at was working at the museum and invited me to fill a year-long term position working on a planetarium show. After the first show, I freelanced elsewhere for a couple of years and then returned as the lead technical director for their next production. Since then, they keep me fairly busy.
HERRON: Tell us about your biggest challenge with visualizing scientific concepts.
PARKER: The biggest difference is that the “clients” are scientists and educators rather than a corporate client. Make a list of the expectations you think a typical advertising or commercial client might have and then flip it upside down! Clearly and honestly illustrating scientific concepts and making sure the presentation is accurate are the priorities. It’s a nice change of pace.
A big challenge is accurately visualizing the many orders-of-magnitude scale differences when doing astronomical visualizations. My director at the museum has always insisted that everything be shown to scale. For instance, a planet might be enormous on human scales, but compared with the distance between each planet – let alone the distances between interstellar objects – a planet becomes much smaller to us than a speck of dust. Animation programs aren’t really set up out of the box to deal with such scale changes. You start to run into limitations for how accurately a computer can process numbers with extremely long decimal points.
HERRON: You’ve also had opportunities to work as a technical director and do lighting for various blockbuster films. What roles did you play?
PARKER: Initially, I did most aspects of 3D animation, then later what’s called “look development,” which is taking rough animation and concept art and then creating realistic surfacing and texturing, and composing the lighting for the shots. More recently, I’ve been doing what’s called “FX” work, which is used for things like snow, smoke, debris, destruction, etc.
I enjoyed working on “Everest,” where myself and a fairly tiny team in Reykjavik created CG snow and avalanche effects for dozens of shots in the movie, all within a few months of production.
HERRON: What’s your secret to staying creative and productive?
PARKER: Daytime is when I need to get things done, so good sleep, caffeine and a long walk at the end of the work day helps. Later at night, I explore new ideas and need to avoid interruptions, so I tend to do that when everyone is asleep. I also get bored easily so I like to keep learning new specialties.
HERRON: What is the most important lesson you learned at Herron?
PARKER: Focusing on painting in a fine arts context helped me in two major ways: to be able to think critically about my own work and to better “see” the world around me.
HERRON: Do you have any advice for Herron students who are interested in the fields of visual effects and animation?
PARKER: Animation and visual effects teams are much like the old guilds of the Renaissance. There are many specialists and many skills can be learned while on the job. But it’s hard to pick up traditional visual skills and critical thinking while working, so having both will be a real advantage.
HERRON: Lastly, what are you working on when you’re not busy with freelance work?
PARKER: I haven’t had much time to work on personal projects lately. I’d like to finish a 3D printed sculpture that I started about a year and a half ago, explore immersive VR [virtual reality] apps, and hopefully paint again soon!
Read the original article from Stories at Herron School of Art and Design