Dancing with Dominicans
A scratchy recording of a vaguely familiar tune plays in the small University of Miami classroom where Paul Austerlitz lectures to a handful of students on the social history of Caribbean music. As a man sings in phlegmy French over lilting guitar and soft percussive beats, Austerlitz explains that the song, "Choucounne," was popular in turn-of-the-century Haiti. Smiling cagily, the teacher turns up the volume a bit, then reveals to his students that this arrangement was later adapted to become the Harry Belafonte hit and steel-pan cruise ship standard "Yellow Bird."
The undergraduate music students stare blankly -- none of them has ever heard of "Yellow Bird." Never mind. The professor shrugs and turns to a stack of videos on the table in front of him. Today's class is dedicated to merengue, the ubiquitous Dominican dance music that Austerlitz has been researching for over a decade. Temple University Press has just published his book on the genre, Merengue: Dominican Music and Dominican Identity. A merengue compilation CD, the companion to the book, is due out this week on the Cambridge-based Rounder label.
Austerlitz's students may not realize it, but "Choucounne" is a well-known example of early merengue, known in French as meringue and called mereng in Haitian Creole. Austerlitz writes these terms on the blackboard, emphasizing that although merengue is now commonly identified with the Dominican Republic, the music is rooted in pan-Caribbean colonial rhythms, particularly the French-derived danza. He turns off the lights and shows a succession of festive amateur videos: Vodou-influenced carnival processions in Haiti and the Dominican Republic; a black fife and drum core in rural Mississippi, followed by remarkably similar footage of musicians playing in a Dominican Christmas celebration; a couple dancing suggestively to a merengue band that plays an African-tinged rhythm reminiscent of Cuban son montuno.
"I want you to hear the entire soundscape that merengue grew up in," urges Austerlitz, a boyish 39-year-old who is spruced up in a suit for a meeting later with the Dominican consul. "You should understand how people felt about this music at different moments in its history."
Austerlitz is passionate about merengue, and in his book he broadens its definition for those who have had little exposure to it outside of the thumping electronic variety commonly played on Latin radio. He documents the complex history and stylistic variations of the effervescent party music -- traditionally played on accordion, saxophone, a drum called a tambora, and gYira (metal scraper). And Austerlitz delves into the social and political significance of merengue in its native country, where for some Dominicans it is a source of national pride, and for others an imperialist form of syncretic music that should be disdained because of its European origins.
A saxophone and clarinet player, Austerlitz started playing merengue by default. He was really interested in Latin jazz; after graduating from Bennington College, he moved back to his native New York City, trying to make some money from his music. "I played in Latin jazz groups and we didn't have any gigs," he recalls. "Since I played saxophone, people started saying, 'You like Latin music. Play merengue. It uses a sax and you can get gigs.'"
He did get some jobs, and even performed with Joseito Mateo, known as the king of merengue, and enjoyed the whole scene so much that he moved to a Dominican neighborhood in Upper Manhattan. Austerlitz, whose mother is from Finland and whose father was a Romanian linguist, learned Spanish and grew a mustache that made him look macho -- he could pass for Dominican. "People called me a Latin wannabe," he laughs. "That was devastating at the time, but it was one of the things that prompted me to think more about what I was doing. It's good to immerse yourself in your subject, but you don't want to lose touch with the strengths you have as an outsider."
Austerlitz subsequently decided to study ethnomusicology at Wesleyan University, where he started his academic research into merengue. Since 1985, he has gone to the Dominican Republic four times for extended periods, most recently on a Fulbright Fellowship last year. On the island, the fact that he could play music along with his sources gave him access to rural musicians who were impressed with his playing and were happy to share their stories.
"Most of my success as an ethnomusicologist has come from being a player," asserts Austerlitz, who recently produced a recording of his original Latin jazz music, featuring Cuban Grammy winner Gonzalo Rubalcaba on piano. He's also looking for a new day job, since his yearlong temporary contract with UM was not renewed. "Playing and researching Caribbean music have been really intertwined for me. I often don't know where one ends and the other picks up," he says.
Merengue compiles the findings that Austerlitz first published in his master's thesis and doctoral dissertation. Unfortunately, the text retains a lot of stiff, academic language; footnote citations that appear in parentheses throughout the book are annoying. Nevertheless, Austerlitz has written a definitive book on merengue that is an important addition to the limited bibliography of informative English-language texts on Latin music. Those who don't want to tackle the book can glean a lot of information from the CD, a sampler of historical and regional styles of merengue with fifteen songs compiled by Austerlitz, who also wrote the explanatory liner notes.
One interesting.”