Looking to make a printer purchase but concerned about how the device may impact the environment? Well, focusing on features like Energy Star compliance, print drivers that default to two-sided printing, and refillable cartridges helps. While focusing on these items will make consumers feel content, other problems will arise: printer recycling programs are among the worst in the high tech market, and it is unlikely they will soon shed that badge of shame.
Green printing touches upon a number of different elements, starting with energy usage. High tech devices have become a key consumer of electricity. In fact, the International Energy Agency estimates that their usage (which accounts for about 3% of all energy consumed in the US annually) will double by 2022.
In response, various government agencies are promoting energy efficient devices via programs like Energy Star. Created by the Environmental Protection Agency and the Department of Energy during the Clinton Administration in 1992, Energy Star identifies consumer devices that use 20% to 30% less energy than comparative systems.
The agency’s standards are dynamic. In 2007, the federal government revamped Energy Star specifications for imaging equipment. Previously, copiers, digital duplicators, fax machines, mailing machines, multifunction (All-in-one) devices, printers, and scanners were housed in separate categories. Now, they are lumped into one grouping.
Better power management has been another area of interest. Like their PC counterparts, printer suppliers have been enhancing their systems so they understand when the device is and is not in use and make necessary adjustments. For instance, a power control feature automatically transitions a printer from a standby mode to an OFF state whenever the computer it is attached to transitions to an inactive state. Xerox Corp.’s Intelligent Ready feature takes the process one step further: it also warms up the printer when a user is most likely to use it.
In addition, printers chew through many consumable elements (paper, ink, toner, cartridges, the units themselves). As far as the units, vendors, such as Xerox Corp., have been trying to develop more standard system designs, so more of the printer can be recycled.
But consumables are the real enemy to the environment. “There (are) ten times more consumables from printing than from the printer itself,” said Federico De Silva Leon, a principal analyst at Gartner Inc. The problems are compounded because vendors have followed a razor/razor blade business model, where they encourage the use of consumables in order to increase their profit margins.
Despite relying on that model, vendors have taken some steps to curb consumable usage. For several years, suppliers have been delivering print drivers that default to two-sided printing. For other systems, users have the option to change the device setting by entering information in the Properties or Preferences settings.
Maybe, some documents simply do not need to be printed. That observation led to the founding of GreenPrint in 2005. The company developed three software programs to help businesses reduce their print volume. GreenPrint Analytics measures print volume for both on- and off-network printers and identifies potential reductions. GreenPrint Advisor uses a color coding system to help end-users identify low cost printer options. GreenPrintpreView+ helps consumers identify and eliminate waste before it is printed.
But each year, millions of cartridges fill up landfills. A handful of years ago, vendors, like Canon and HP, introduced cartridge recycling programs. Yet, such efforts have been largely ineffective, according to the Electronics TakeBack Coalition (ETBC), a consortium designed to encourage recycling of electronic products. In 2010, the consortium graded printer vendors’ recycling programs. “All of the vendors flunked except for HP, who received a C minus,” noted Barbara Kyle, National Coordinator at ETBC. “Printer vendors do not take recycling seriously.”
One reason for the low grades is that suppliers offer mail back or bring back programs, where the onus is on consumers to recycle the items. Most people won’t take that step. The recycling programs would only be more effective if they were simpler or offered consumers more of a financial incentive, according to ETBC’s Kyle.
Also, the recycling numbers that vendors cite tend to amorphous. They tout millions of pounds of products being reused but do not put the numbers into context by stating what percentage of their yearly device total is. “Estimates are that only about 30% of cartridges are recycled,” stated Gartner De Silva Leon.
So for the moment, it appears that printer vendors will continue to receive low grades from environmentalists. “A change in how vendors view recycling programs will come, but it will take time because so much of their business model – and mindset – revolves around encouraging customers to use more consumables,” concluded Gartner De Silva Leon.
Learn more about how technology affects the environment and best practices on reducing your footprint through our Taking Technology Green Special Report!
TechTarget publishes
more than 100 focused websites providing quick access to a deep store of
news, advice and analysis about the technologies, products and processes crucial
to the jobs of IT pros.
All Rights Reserved, Copyright 2000 - 2015, TechTarget | Read our Privacy Statement