CodePlexProject Hosting for Open Source Software
I am writing some Unit Tests and I have noticed that certain tests do not run. I noticed this while writing tests for symmetric matrix but the same applies to the already implemented diagonal matrix. There are two distinct types of such tests:
- Tests that have been "crossed out". What I mean is that some tests appear in the R# test runner with a red strikethrough and are not executed.I have noticed that these are test methods on child classes that override test methods on the parent
class. When overriding, neither the parent class test nor the child class test is executed.
- Tests that simply don't execute for no apparent reason. They appear grey in the R# test runner and are not marked as Failed or Ignored, just nothing.
Both cases can easily be observed when running the Diagonal Matrix tests (I go to DiagonalMatrixTests.cs and click the yellow-green icon next to the class declaration). I have been trying to find out what the deal is with this problem but haven't figured
it out and googling didn't help either. I am also unsure whether or not I should declare the [Test], [TestFixture] etc attributes on the parent as well as the child methods/classes. Judging by the DiagonalMatrixTests.cs, the attributes are inhrerited
and need not be declared again but I tried both re-declaring them and not re-declaring them and they both fail anyway.
Is this only occuring to me? Any insight is greatly appreciated.
Screenshot here shows the two types of failed/ignored tests.
The Resharper 5 test runner doesn't support NUnit 2.5.9 (I believe it only supports up to 2.5.7). So some test don't run (not 100% sure but I think they are using 2.5.9 features). The tests marked as ignored are mostly ignored because of precision problems.
After beta 2, we'll go back correct those.
Are you sure you want to delete this post? You will not be able to recover it later.
Are you sure you want to delete this thread? You will not be able to recover it later.