Building a strong, well-balanced startup team is no small feat, and retaining good talent is even more challenging. That’s because nowadays there are very few “lifers” (people that stay 10-30+ years in one place) and more people who hop from job to job. An 2010 Intuit study predicts that by 2020, 40% of America’s workforce will be contract, temporary, or self-employed workers. On top of that trend, co-founder relationships remain tenuous. Currently, co-founder conflict is the number-one startup killer; 65% of startups fail due to co-founder strife, according to Noam Wasserman, a Harvard Business School professor.
How do you overcome these hurdles and excel at assembling a talented team for your business? Here are some key things to consider:
1. Find the right co-founders.
Should you go it alone or get co-founder(s)? Choosing to go solo or partnering with co-founders both have pros and cons. While neither is easy in the beginning, each have different results in the long run. In a TechCrunch article that analyzed top unicorn startups, the author found that only 10% of successful startups were led by solo founders. And according to First Round, teams with more than one founder outperformed teams with solo founders by a factor of 163%. While you can still be successful on your own, the odds of success increase when you have a co-founder. There are plenty of resources to help find your ideal co-founder, such as CoFoundersLab and in-person meetup events.
2. Recruit influential advisors.
Seek to recruit advisors who balance your weaker areas to ensure that that you have comprehensive support. Most people’s first instinct is to find individuals who are like themselves, but you must resist the temptation. Pick advisors who you respect and who have deep expertise in key areas.
Remember: Disagreements are healthy and essential to innovation. A homogenous organization is more likely to experience stunted growth because too many ideas go unchallenged. Advisors should have the necessary expertise to provide guidance during challenging times. While they do not have all the answers, advisors are effective because they reduce friction and ask the right questions. To get the most out of your advisors, you must allow them to help you and encourage them to openly submit their feedback. Also, you must always remember that your advisors are people before they’re advisors; form a relationship with them that goes beyond their role at your company and any similarities you might share.
Related: Learn how to bring on great advisors
3. Partner with strategic board members.
Board members are individuals appointed to ensure that companies are meeting their fiduciary duties and to manage corporate governance. Typically, they’re personally liable for any company misconduct. To this end, the board helps hold the executive team accountable for delivery and execution and ensures that the company is in good health and following through on its strategy.
The CEO meets with the board periodically (monthly or quarterly) to review progress, receive approval, or discuss pending decisions. Founders should begin building their board as soon as possible. It’s common for board structures to start small and grow over time in parallel with the company’s growth. Boards are typically comprised of major investors, founders, and, for larger companies, independents who can bring their expertise to the organization.
A typical startup board may have only three members, but that number may grow to five or more after the first round of real funding. Be judicious in who you invite to be a member of the board. And don't forget that you can add certain strategic partners as board observers. These board members can assist the company and participate in meetings without assuming the legal liability and control issues associated with a full board seat.
4. Make sure your first hires are rockstars.
Time is always of the essence in the startup world and you can increase your odds of success by hiring top talent from the start. The benefit of hiring leaders (as opposed to followers) is that they are not afraid to think differently and push you into uncharted territories. By surrounding yourself with smart and experienced people, it elevates the entire company and sets the tone for your company to act as a change agent in its field.
Related: How to master first hires
5. Set up your company practices to be data-driven
No matter the company, every leader wants to know how well they are performing and how to make the right strategic decisions. A/B testing is a great way to guide strategic decisions. Avoid leading the company based on your personal preferences as a customer, and be sure to leverage various tests to let the market dictate what resonates best.
By leveraging data to make strategic decisions, you’re able to remove the bias that you likely bring to the decision-making process. Additionally, you’ll be creating a culture where team members feel empowered to make bigger decisions and take on more responsibilities because data is giving them new, unique insights in the company. A data-driven approach makes for a truly scalable and holistic way of leading.
To build a strong team, you’ll need a multi-tiered approach that includes: 1. The right team structure at the outset 2. The right people for each role and 3. An empowered team that grows by using data to make insightful decisions.