This is a joint blog post between Otus and Project Unicorn, an educational advocacy initiative dedicated to the secure, controlled interchange of data within K-12 education. Earlier this year, we partnered together around a common goal of interoperability.
Whether we’re teaching our students or developing the technology they use in the classroom, our goal is the same: we want to see students succeed academically, cognitively, and socially. With the edtech landscape maturing, we have new tools to help us get closer to achieving our goals, but unless those tools work together and responsibly share their information, we won’t get there. In order to develop a technological ecosystem that teachers can navigate to unlock the insights and potential of their classroom data, we need interoperability. In this article, we’ll work through what this term means to educators and district leaders, why blended and personalized learning is so important, and ways that you can move towards interoperability in your district. Data will never replace great teaching, but it can help our educators and district leaders understand and bolster their students’ paths to success.
WHAT IS INTEROPERABILITY?
The term interoperability is confusing or unclear to many people – so much so that the word itself can be somewhat of a deterrent to realizing its importance in education. The official definition of interoperability, according to Project Unicorn is the seamless, secure, and controlled exchange of data between applications.
In other words, having interoperability (in the classroom) ensures that all of your learning, assessment, classroom, and data management tools talk to one another – which means running a classroom is easier for teachers because the relevant tools, resources, and student learning information can be accessed in one place. This degree of accessibility saves teachers time (which, in a non-interoperable classroom, is wasted on managing multiple applications and portals which have nothing to do with one another) that can be better spent helping their students.
Defining interoperability is the first step, but the greatest challenge is not getting educators to understand what interoperability is. Rather, it’s convincing them why interoperability should matter to them personally.
WHY DOES INTEROPERABILITY MATTER?
When a teacher’s learning and classroom management tools talk to one another, the teacher has greater capacity to create a personalized learning environment for their students. Most of the time, information about students is scattered across a disparate platforms – grading and homework platforms, attendance trackers, behavior and performance gauging systems – all of which must be accessed individually for each and every student.
Not only this, but the information we want to know about students (strengths, passions, interests, purpose) isn’t readily available to paint a holistic picture of who are students are! An enormous amount of effort is required for teachers to fully understand the academic, cognitive, and socio-emotional status of every child in the classroom. And teachers, more often than not, must gather all of this data from the various locations. What if there was a way for teachers to access all tools, all systems, and all data in the same place? There is a way, and it is through interoperability.
Project Unicorn’s Interoperability Rubric ensures easy assessment of interoperability in classroom tools. On a 1-to-4 point scale, a teacher can determine where his or her edtech tools fall – earning one point means the tool is not interoperable at all, while earning four points means the tool is completely interoperable. The rubric is unique in the industry, and we encourage all educators to use it when researching edtech tools, as it is designed to make their lives easier in the long run.
HOW TO OVERCOME THE LACK OF INTEROPERABILITY
Here at Otus, we’re approaching the obstacle of interoperability by building a “pre-integrated” student performance platform. Rather than using 6-8, or sometimes as many as 12, individual edtech solutions, Otus takes the best of each and puts them into a single platform. This is Otus — Data Management, Assessment Management, and Classroom and Learning Management, all together. Moreover, Otus helps teachers email or text parents, create student portfolios, and compile a student profile created through our partnership with Thrively and your district’s academic data.
Teachers and administrators are freed up from the tedious work needed to maintain multiple systems so they can spend more of their valuable time engaging the students and learning together. This is why our work and partnership with Project Unicorn is a top priority for us. We both agree the lack of interoperability can be a barrier to good teaching and the overall learning experience for students. In accordance with the mission of Project Unicorn, Otus is simplifying working with data and technology for teachers so they can do what they do best: teach.
Project Unicorn does not endorse a specific product or data standard but instead is an educational advocacy initiative dedicated to the secure, controlled interchange of data.