Cameras watch us almost everywhere we go. We know the internet tracks our searches and purchases, and our smartphones can be used to monitor our activities too. As sociologist David Lyon points out, "this is a culture of surveillance."
In this watched world, our data is compiled into products to be used by businesses, not only to discover what we buy, but to understand how we are doing financially.
Credit reports, compiled from the data associated with financial transactions, reveal a great deal about us: How much we owe, how much we can borrow, whether we make payments on time and the names of creditors that have accessed the file. These reports may also include "local public records, social networking patterns, academic achievement records, mobile phone usage and non-financial payment histories."
I predict the next step in our watched world is the creation of a "wellness report" for each person. Like a credit report, a wellness report could collect all those little pieces of health-related data to paint a picture of our health or document possible illnesses.
Predicting the future
Wearable technology, smart watches and smartphones are already collecting our health data. They track your distance, speed and heart rate, and some can even note if your heartbeat was irregular.
But what if they went further, combining those little bits of data from wearable devices with medical appointments or food logs, stored in apps on your phone, plus the health products you buy and the prescriptions you fill, all recorded on your points card?
Many apps are already gathering information that is unrelated to their primary consumer use. For example, of the more than 300 apps studied by the Yale Privacy lab, 75 per cent host third-party trackers collecting data on our activities.
Taken together, a description of your health and behaviour begins to emerge.
Those who are very fit or healthy might see this as a good thing. However, technical glitches do occur and, when it comes to health, there is a wide range of "normal." So, even if you are healthy, you could be at risk.
Health data could be used like credit data to group users based on their behaviour and risks and create categories of wellness that influence your choices going forward.
With credit scores, our future credit-worthiness is extrapolated from our current borrowing behaviour. Credit scores control access to homes, vehicles and other consumer items. They help some people, generally those with steady jobs, and hold back others, including those who work part-time or are underemployed and can't always make payments on time.
The same might be true for a wellness report, with future illness probability derived from symptoms detected by your apps and wearable tech.
Banks, businesses and credit lenders provide financial support to credit-reporting companies. In return, they receive data that indicates their risk when they loan money. People with low credit scores are considered higher risk, and as a result, they have more difficulty getting loans or face a higher cost of borrowing —generally in the form of higher interest rates.
A wellness report could be a resource for private insurers, medicare and health-care providers to gauge the risk associated with providing a service. For example, a hypothetical wellness score —based on data collected and aggregated in novel ways —could determine how much you might pay for travel and health insurance —if you receive it at all.
In this hypothetical future, your travel insurance premiums might go up if your smart watch records heartbeat irregularities, especially if this is combined with data from an app that takes note of your appointment for a heart-screening test, or a points card that records your Aspirin purchase.
It's also possible that your health data could negatively affect your eligibility for certain health and medical procedures. For example, a procedure might be denied if your wellness report indicated that you might have an undiagnosed illness that could lead to complications.
Unhealthy errors
Credit reports are built and maintained without permission or notifying the reportees. They are notoriously difficult to monitor and correct.
A wellness report, if developed, would face the same complications. Errors might take days or months to correct, and might require experts or medical tests to disprove.
Like credit reports, errors in data reporting could harm those with flawed reports. The harms to the individual will be far greater than the costs to insurers.
For example, what if you were drinking coffee like it was water to stay ahead of a deadline, and the data from your wearable device and phone apps merged to show that you had high blood pressure or a slightly elevated heart rate? If this data were compiled into a wellness report, you might find travel insurance more expensive —or skydiving school out of the question.
Older adults are especially vulnerable to the negative impacts of health surveillance. Illness and disease become more common as we age, and the early warning signs may be detectable long before the disease impacts our lifestyle or behaviour. When it comes to health or travel insurance, older adults, many of whom who have fixed incomes, may be faced with higher premiums they just can't handle.
And what if credit and wellness report data was combined? Where would that leave the vulnerable?
Although countries offer advice and safeguards to protect consumers, the only way prevent this kind of data collection and compilation is through legislation.
We need to talk about these privacy concerns now, and insist on government protection, before private insurers and health providers invest in novel applications of already existing data to create and use wellness reports to protect them from risks —not us.
Explore further:
Poor credit scores, poor health
Please sign in to add a comment. Registration is free, and takes less than a minute. Read moreClick here to reset your password.
Sign in to get notified via email when new comments are made.