In the radiation safety field, one of the most frequent questions we receive is "What are the differences between all of these types of detectors - and in what circumstances should i use each one?" Without an in-depth knowledge of health physics and radiation detection equipment, it can be a real challenge to tell the difference between equipment types. Especially with all of the acronyms and technical specifics that are tossed around.
Today we'll be trying to shed a little light on one commonly used type of instrument - the Personal Radiation Detector or PRD.
An introduction to the basics of sensitive radiation detection
The most common types of radiation detection equipment, such as survey meters and dosimeters, are intended for specific uses and not ideally suited for dealing with radiation security threats. They were designed primarily for hand held measurement or monitoring personnel in situations where radiation is expected. But the growing desire for governments and security officials to be able to quickly and easily detect and intercept radiological threats requires a more advanced type of detector. From this need the Personal Radiation Detector was born.
The original idea behind a radiation detector for security applications, such as customs and border protection, was to develop a lightweight, small, easy to use, and (most importantly) highly sensitive detector. Able to search for and rapidly detect low levels of radioactive material, the personal radiation detector is a versatile tool for locating potential threats or areas of concern, allowing further screening and investigation to be done as needed.
Radiation survey meters of the type commonly referred to as “Geiger counters,” tend to be larger and less sensitive by design. Their primary purpose is looking for larger sources of radiation, or mapping out the boundaries of a known field. These devices use Geiger-Müller tubes (hence the common name) or ion chambers as the primary detector. While very useful for their intended purposes, these detector types provide some drawbacks when turned towards applications that require more sensitive detectors, with faster response times.
For Geiger-Müller tubes (GM Tubes), a primary concern is that the only way to increase the sensitivity of the detector is to add a thinly shielded window, which reduces the durability of the device. Alternatively, you can increase the size of the detector itself, but this forces the overall instrument to be much larger as well. When the situation calls for a small, rugged, easy to use device, this becomes problematic.
Also, for both GM tubes and ion chambers, there is no differentiation between types of radiation on the detectors themselves. No data is provided on the types of sources encountered from the detector elements themselves. They basically register as “radiation”, and how much, or “no radiation” at all.
Given these limitations, a different type of detector, the scintillator, is regularly used for PRDs. A scintillator is a material, usually a crystal, which gives off a photon of light when struck by radiation. They are coupled with a PMT (photomultiplier) tube, which amplifies that signal. This produces a very efficient and very sensitive detector. The overall sensitivity of the device is determined by the size of the detector. Additionally, the pulses vary in strength depending on the type of radiation, or even specific source, they are exposed to. So, it becomes possible, with certain ranges of personal radiation detectors, to actually be able to identify the source of radioactive material while in the field. This type of device is call a Spectroscopic Personal Radiation Detector, or SPRD.
These technological differences lend themselves to very different applications.
PRD's vs. other Types of Instruments
Generally, hand held radiation detection equipment falls into three broad categories. The first, represented by badge dosimeters or electronic dosimeters, is personnel monitoring. These devices are designed to record dose exposure to the wearer, usually because they expect to be around radiation as part of their work, and need to be aware of exactly how much radiation dose they absorb.
The second major category of radiation detection instruments is hand held measurement. The iconic, clicking, box-shaped survey meter fits into this role, as do a number of other hand held survey instruments. These are used for detecting the general presence of radiation in a given area, or for quantifying a known radiation area, as well as identifying the boundary between it and a "clear" area. Also included is the contamination frisker, used to make sure no contamination is present on anyone or anything moving between zones.
Being especially useful when looking for sources that are hidden or shielded, the personal radiation detector falls into the last group of instruments, sensitive detection and identification. Used for scanning shipping containers, luggage, people, and more for hidden radioactive material, they are perfect for security checkpoints and border stations. It is in this capacity that the PRD proves most capable, and it's this thinking that drives their design.
Personal Radiation Detectors are ideally suited for security applications that need fast, accurate detection. In use cases like event security, border protection, and law enforcement, the PRD provides a high level of sensitivity in a small and easy-to-use package.Personal Radiation Detectors are ideally suited for security applications that need fast, accurate detection. In use cases like event security, border protection, and law enforcement, the PRD provides a high level of sensitivity in a small and easy-to-use package.
Radiation detection meant for personnel monitoring or measurement are generally in the hands of people expecting to find radiation. These individuals work with radiation as part of their day to day jobs. These are situations where risk of exposure to the public is very limited and government regulation of both sources and exposure is tightly controlled. However, in radiation security applications, radiation is not only unexpected, but unwanted and potentially dangerous. In this case, fast, sensitive detection is important, and the personal radiation detector is a key component in responding to potential threats.
We'll be exploring Personal Radiation Detectors in a little more depth in the coming weeks, including specific applications well suited to their use. From there we'll move on to talking about radiation spectroscopy, and how it builds on Personal Radiation Detector technology to provide a more advanced tool for radiation security.