In working on my spare-time app BostonBusMap, I’ve repeatedly run into problems where I need to cut down on memory usage or running time. It’s not difficult to hit memory limitations on Android, especially on earlier devices which may allow only 16MB per app. Garbage collection can cause noticeable hiccups (especially before Android 2.3), which is one reason why memory usage can impact an app’s sluggishness. Here’s a list of things I did to make my app more responsive:
- First, read the Android performance guidelines. It’s also worth rereading this page from time to time because newer Android versions have more advanced capabilities that may influence the optimizations you make.
- One other important thing that bears repeating from that page is, don’t optimize unless you can show that there’s a bottleneck, because optimizing is a lot of work and can make code less maintainable
- Memory allocations are expensive. Be lazy in allocating objects if they are only used in edge cases
- Use DDMS. This is available within Eclipse and as a standalone tool:
- Profile against smaller amounts of data at first, to make the experience less painful and time consuming for you. Debugging will slow your app down in general
- Click on the green cylindrical icon to the left (called “Update Heap”) to turn on heap tracking for a thread. This will update whenever a garbage collection occurs (you can also force garbage collections) 