The design business is filled with semi-professionals and those looking to find their way, but not Ellen Winkler. A leader in the design business for more than two decades, she’s a reliable leader, and accomplished designer.
Thanks for joining us, Ellen. Tell us a little bit about how you got started in interior design.
My grandmother was an excellent seamstress, so I had an inherent interest in fabrics and design. I owned and managed a workroom for several years and then enrolled in an interior design program. I went on to pass my NCIDQ (National Committee of Interior Design Qualification) and was President of the New England Chapter of the ASID (American Society of Interior Design) in 2000-2001.
New England is a wonderful place to work with design. Which classic New England features do you try and incorporate into your designs? How do you try and limit it?
I’ve found design trends in New England are influenced by several factors, including the location (mountains, lakefront, oceanside, rural) combined with the homeowners’ personal taste. Many of our clients have second homes in the Lake Sunapee area and while they want their home to be indicative of a lake home, they often blend this style with a more contemporary or eclectic one, which is exactly what I strive to help them achieve.
We work with clients closely throughout the design process. At the first consultation I do much more listening than talking, allowing the homeowners to tell me their likes, dislikes, goals, and dreams. We develop the design through a collaborative processing involving sketches and samples to visualize the end result of the space.
Describe some of your more challenging spaces? Does a unique layout benefit the designer by expanding their ability to be creative? Or does it limit options?
Spaces that can be particularly challenging, especially in regard to space planning and furniture layout, are long rectangular rooms with a lot of windows, doors, and large fireplaces. One recent client had such a room, where an oversized stone fireplace and hearth took up one end wall with a door located to the side of it. Typically, the fireplace creates a focal point for seating to be arranged, but in this case there was only enough room for two chairs and small end tables to be located at the end of the room with the fireplace and door, leaving the rest of the room in want. I drew several floor plan options for the client with two separate seating areas, incorporating chairs and an ottoman that are easily movable to accommodate large or small parties.
Unique layouts do force the designer to be more creative. Traditional New England homes have many additions onto a main structure which mean more doorways to work around, and often older homes have more than one fireplace not particularly in the best location. By understanding how the clients want to use their space and their current lifestyles, I can suggest storage techniques that will work in their space, i.e. built ins, cabinets, shelves, hidden storage in a coffee table, etc.
Options are only limited by the designer’s imagination and the clients’ receptiveness to his or her ideas. The better we know the client, the more options we have to present.
Open floor plans are more popular than ever and many clients are consumed with the idea of flow. How do you ensure against clutter, and that the occupant always feels stress-free in that space?
Traffic flow is an extremely important interior design consideration. Open floor plans present more of a challenge in that basically everything is visible to the guest; however, there are several design options that can organize clutter, limit it, or at the very least contain it. The kitchen pantry is a godsend for the client who spends a lot of time in the kitchen, housing large and small equipment, mixing bowls, and even food items which would normally present a storage challenge in an open, contemporary kitchen layout. Open pantries can be organized in such a way as to focus on specific items, such as a collection of dishes, rather than the ordinary items generally found in the pantry.
Built-in entertainment centers in family rooms can also be useful in keeping books, games, and sports memorabilia contained while creating a showcase for personal achievements such as metals and trophies.
Area rugs are versatile. New England homes and businesses use lots of hardwood floors. Explain how you incorporate area rugs into your designs.
It’s true New England homes and businesses have a lot of hardwood floors, but seldom do you see one without an area rug. Area rugs contribute so much to the design of a room. I love designing rooms around colorful area rugs and often let the rug selection dictate the other design elements in the room. I also design the rug and select the color palette for the perfect piece in a room.
After interviewing my clients and developing a color scheme, we start researching rugs with the colors and pattern style that will complement the space. Our vendors who work with custom made rugs email pictures of their current supply of rugs that might match the space for our consideration, or if we are designing a whole house, we travel to the vendor’s warehouse to select all of the rugs at once, ensuring they work together and create a design flow from space to space in the home. The area rug references the theme of the room and often repeats design elements. Both color and texture reinforce and influence the activities use of the room.
Rugs can also help create a cohesive design when bringing furniture from one location to a new one, or combining furniture from two homes into one.
Do you have a type of area rug that you lean on most? Or is it a case-by-case basis?
I really select rugs on a case by case basis, but I typically use 100% wool with vegetable dyes for the clarity of color tones and durability. Man-made components such as nylon give years of service in more utilitarian areas.
Are there price limits when it comes to rugs?
There really is no price limit on rugs. Most are made in Afghanistan, Pakistan, and Nepal by true craftsmen who have worked in the trade for decades. Some, with intricate designs and a high knot count, can easily reach $10,000, depending on the size and thread count. Antique rugs area a wonderful alternative and often fit best with no budget. There are several good options, though, to keep within any budget.
Do you have any final words of design advice?
Where can readers see your work, or make an appointment for consultation?
Our website showcases our portfolio of projects all over the country. We travel to potential clients’ homes for consultations, or if it is more convenient, we have two office locations for appointments – our Showroom and Design Center in New London, New Hampshire, and a satellite office in Cambridge, Massachusetts.