TEDMED brought a relentless optimism about healthcare reform to a city of tired ideas. More is needed, however, to make a difference in Washington, DC.
Facebook/TEDMED
WASHINGTON, DC - Perched on the banks of the Potomac River, the TEDMED gathering weighed in last week on what it considered the greatest challenges facing healthcare.
A meeting closely associated with the high tech-optimism of Silicon Valley and other outposts of America's innovator class, TEDMED came east this year from it's previous home in San Diego. The idea was to bring the gathering's ethos and its troupe of entrepreneurs, thinkers, futurists, doers, and artists to our nation's political capital.
It's unclear whether Washington was listening during the three and half-day day assembly, since much of the establishment here was away on Easter-Passover break. But National Institutes of Health Director Francis Collins gave a talk. And so did Commissioner of the Food & Drug Administration Margaret Hamburg, along with a few other Washington types, even if they mostly didn't stay and mix in the usual TED fashion.
Still, the 1700 attendees did engage in an activity that Washington understands - an election.
The delegates - many of whom paid $5,000 to be there - voted for one of 50 "Great Challenges" facing healthcare that they believed was most worthy of attention. They were joined by thousands of non-attendees following the meeting for free on simulcasts and on the organization's website.
Sponsored by the nonprofit Robert Wood Johnson Foundation and the TEDMED organization, the challenges included The Obesity Crisis, Eliminating Medical Errors, End-of-Life Care, Impact of Poverty on Health, and Medical Information Overload.
The list included some perennial Washington obsessions such as Addressing Health Care Costs, but did not include other DC favorites such as the solvency of Medicare and Medicaid and the future of Obamacare.
The soft-pedaling of politically touchy issues was in line with the wishes of the new curator of TEDMED, Jay Walker, who decided that the meeting would avoid contentious content during its first outing in DC. An inventor and the founder most famously of Priceline, Walker's company, Walker Digital, acquired TEDMED last year.
Not everyone in the TEDMED community agreed, given that this is a political town and issues can be discussed without taking sides. Personally, I believe that a TED meets Washington airing of issues could be exciting. Walker, however, wanted to stay with the tradition of TED, which stands for Technology Entertainment & Design - but not politics.
Each of the 50 challenges at TEDMED were represented by an "advocate" - entrepreneurs, physicians, hospital executives, patient representatives, and others. At the last minute, probably late at night, a challenge #51 was added to the list - Sleep Deprivation - hardly a shock at a meeting of over-achievers.
Some of the advocates campaigned hard for their challenge, donning buttons and t-shirts and passing out cards and flyers.
For instance, one morning on a bus taking me to the meeting place at Kennedy Center, a personable young physician named Rajiv Kumar thrust out his hand and a card encouraging me to vote for his challenge - Inventing Wellness Programs that Work.
"70 percent of Americans don't exercise regularly," he explained, telling me he had co-founded a company in 2006 called ShapeUp. Based in Rhode Island, Kumar's business company is using data and the latest Health 2.0 tools to help other companies incentivize their employees to be more fit, to improve health and to save money.
In another nod to Washington, a few advocates enlisted the deeper pockets of well-healed sponsors such as the Cleveland Clinic. Their Chief Experience Officer, physician James Merlino, campaigned for Improving Medical Communication. His flyer quoted George Bernard Shaw: "The single biggest problem in communication is the illusion that it has taken place."
And now, the envelope please.
The winner was: Inventing Wellness Programs that Work - Rajiv Kumar's challenge. This candidate brought in a staggering 10% of the vote, twice the percentage of the second place winner, which was The Caregiver Crisis, polling at 5%.
Third place was a tie, with Role of the Patient polling the same as The Obesity Crisis, each getting 4% of the vote.
Fourth place was a seven-way tie at 3% each, which included Improving Medical Communication - the campaign assisted by the Cleveland Clinic.
The top 20 winners will become the focus of projects over the next year.
Some challenges that didn't make the top-20 cut were Isolation and Loneliness, Special Needs Patients, Unwed Teen Motherhood, Reducing School Violence, and Malpractice Dilemma.
If there is a take-away from this election, it's that this self-selected group of forward-looking people believes that healthcare reform should focus much more on keeping people healthy and engaged in their own healthcare.
This is not surprising among these highly motivated self-starters, who include an outsized number of people who are vegetarians, yoga practitioners and techies. Yet I wonder if a greater challenge is how to translate this sensibility to the non-TEDMED-minded, such as those 70% of Americans that Rajiv Kumar said barely exercise or the 535 members of the House and Senate working up the hill from Foggy Bottom, where the meeting was held.
I'd also encourage a stronger push by Jay Walker and the TEDMED community to truly engage with Washington and the powers that be. This would mean converting the talk about innovation - combined with the powerful confidence of a culture that fervently believes they can fix things, and sometimes succeeds - to a real process of re-energizing health reform.
Washington certainly could use an entrepreneurial reset of fresh ideas from beyond the Potomac and its slow-moving waters. Perhaps this is the intent of Walker and company - to tiptoe into town this year to establish a presence, and then next year to pounce.