I thought I would share an article I wrote in Low Country Weekly Magazine. It is about fear, exercise and movement.
“A client recently told me that one of her friends is thinking of joining local a training facility, but the friend is afraid that she won’t be able to keep up. She worries that her body is too out of shape to get started. She has had a myriad of health concerns and is only in her 30s, but her fear of an exercise program is greater than her health fears at this point. Her fear of exercise is not uncommon, but it is an attitude that I would like to address.
The body is designed to move. In fact… it is designed to move a lot.
When immobile, the body malfunctions mentally, physically, emotionally and spiritually.
When the body is devoid of movement, signs and symptoms pop up – like disease, aches and pains, poor health, muscle atrophy, irritability, frustration, guilt, shame, back pain and even cancer.
Having taken thousands of people through training programs, I see people change their belief systems about their body’s ability all the time. I find that initially many people think their body is weak and fragile, and this can cause fear. This fear is destructive to growth and health.
A common barrier preventing people from engaging in physical activity or exercise and training is the fear of injury.
I think it is also important to acknowledge that people experiencing depression move less. Typically, the less you move, the worse you will feel; and the worse you feel, the more fearful you become. Low feelings permeate every aspect of our lives – from personal relationships to relationships with food.
When people are depressed, the biochemical reaction taking place can result in a total shutdown of body, mind and spirit. A way to combat this decline is by connecting your body to your brain through movement to activate the necessary neurotransmitters or “feel good” chemicals. Just movement will elevate the mood. Because of extensive research on this subject, exercise is the major weapon in the psychiatric arsenal, and it has been proven more powerful than any pill.
Individuals struggling with obesity or being overweight also move less. Research has found that at least 1 in 5 deaths are associated with obesity, and being overweight increases the risk of disease in general. The combination of being overweight and moving less is deadly.
This is the reason people find their body weak and fragile – because it becomes weak and fragile through less activity over time, and their confidence and self esteem declines.
The lack of movement can snowball into severe health issues, which can be compounded with a diet void of essential nutrients.
Movement through exercise is key to normalizing body weight, mental and emotional function, and by default, encourages more conscious eating habits.
Have you heard, “Sitting is the new smoking?” When you spend the majority of the day sitting, there is a lack of blood flow, nutrients, and energy within the body.
As a back pain relief specialist, I often see people associate a specific movement or moment in time with back pain. The truth is, if you have back pain it is rarely the result of one acute incident, but rather that of chronic incorrect movement patterns, inflammation, or general lack of movement for years, creating weakness in the muscles that support the body as a whole; and many times the culmination of that weakness ends up affecting the area with the most stress, the lower back. The key is to move more and to keep all the muscles strong, stable, mobile, warm and filled with new blood, oxygen and nutrients. Just doing that will prevent 90% of all aches, pains, and ills.
We know injuries are going to occur; it is pretty much a guarantee – part of life. For example, almost everyone at one point in time will experience back pain. We need to accept that fact and not let it deter us from engaging in life.
Just in the last couple of months we’ve had clients that injured themselves doing the most mundane things: laundry, moving in their sleep, pulling luggage, and making their bed. So it happens.
But… limiting your movement is the most dangerous thing you can do.
The key is, do not let fear freeze you into a state of inactivity. Minimize risk by ensuring your movements are safe and stable, and in a non-threatening environment. If you are just beginning an exercise program, be sure to progress gradually. The likelihood of injury increases when jumping too fast, too soon into an exercise regimen when you’re not prepared, or when you lack the knowledge to execute movements properly. Even though injuries can occur from time to time, the effects of not exercising are more harmful and devastating to your body. Move more and you will feel better, get stronger, be happier and more confident.”
Committed to your success,
Ian.