At a Glance
Plasma cell myeloma is a bone marrow-based clonal plasma cell proliferation. It comprises 10-15% of hematopoietic neoplasms. It is typically diagnosed as a result of evaluations for anemia, renal failure, and/or bone lytic lesions. When serum or urine protein electrophoresis studies detect a monoclonal immunoglobulin (paraprotein, M-protein) secreted by these neoplasms, the patient is described as having a “monoclonal gammopathy.”
Immunofixation determines what the heavy and light chain restriction is for the myeloma. For myelomas, approximately 50% are IgG, 20% IgA, 20% light chain only, and less than 10% for IgD, IgE, IgM, and biclonal combined. Three percent are nonsecretory. The finding of an IgM monoclonal protein makes the possibility of myeloma unlikely. IgM monoclonal gammopathy is usually associated with a B-cell lymphoma, most commonly lymphoplasmacytic lymphoma, but other B-cell lymphomas, such as marginal zone lymphoma or chronic lymphocyte leukemia/small lymphocytic lymphoma (CLL/SLL), are possibilities.
What Tests Should I Request to Confirm My Clinical Dx? In addition, what follow-up tests might be useful?
A bone marrow aspirate and biopsy is usually obtained to detect and quantify the percentage of monoclonal plasma cells (morphologically, by manual differential count of aspirate smears, special stains/immunohistochemistry, and in situ hybridization and/or flow cytometry for immunoglobulin light chain locality), as well as to provide material for cytogenetic analysis, which is of prognostic significance. Some institutions do not routinely perform flow cytometry for plasma cell neoplasms due to plasma cell fragility during processing. Bone marrow biopsies are also assessed for amyloid deposition, an amorphous material within vessel walls that can be demonstrated by Congo red staining with a characteristic “apple-green” birefringence.
In the setting of an M-protein and bone marrow clonal plasma cells, demonstration of related organ or tissue impairment (“CRAB”-hypercalcemia, renal insufficiency, anemia, bone lesions) automatically means “symptomatic plasma cell myeloma,” regardless of M-protein levels or plasma percent in the bone marrow, although the plasma cell percentage typically exceeds 10% of marrow nucleated cells.
“Asymptomatic or smoldering lymphoma” is diagnosed when the serum M-protein is at “myeloma levels” (greater than 30 g/liter) and/or there are 10% or more total plasma cells in the bone marrow, without related organ or tissue impairment. These patients may have stable disease for long periods, but the cumulative probability of progression to symptomatic myeloma or amyloidosis is 10% per year for the first 5 years, 3% per year for the following 5 years, and 1% for the subsequent 10 years. If the M-protein is less than 30 g/liter and there are less than 10% of bone marrow total plasma cells and no organ or tissue impairment or a known B-cell lymphoma, the diagnosis is “monoclonal gammopathy of undetermined significance (MGUS).” The clinical course in most of the latter patients is stable, with only a 1% risk of progression per year. However, myeloma or amyloidosis can develop even after 30 or more years.
What Lab Results Are Absolutely Confirmatory?
Clinical and laboratory studies, such as M-protein levels, hemoglobin, creatinine, calcium, and beta-2 microglobulin levels, as well as imaging studies to evaluate the number of bone lesions, have been used in different staging systems for the disease.
The finding of circulating plasma cells on review of a peripheral blood smear, which the pathologist will examine along with a bone marrow aspirate and biopsy, is an ominous finding. A diagnosis of “plasma cell leukemia” is made when circulating plasma cells comprise 20% of leukocytes in a peripheral blood smear or exceed 2×10 9/liter. Plasma cell leukemia is a very aggressive disease with a short survival.
Cytogenetic findings have been recognized to provide prognostic information. Conventional karyotyping is routinely performed as part of the bone marrow examination and detects abnormalities in approximately one-third of cases, depending on the presence of plasma cells in the sample. Ffluorescence in situ hybridization (FISH) studies, performed selectively on interphase plasma cells, are becoming standard of care and will detect abnormalities in more than 90% of cases. These include structural abnormalities, such as translocations and deletions, and numerical chromosome abnormalities.
The most frequent translocations involve the immunoglobulin heavy chain locus IgH at 14q32, which occur in 55-70% of tumors and involve five major oncogenes: cyclin D1, C-MAF, FGFR3/MMSET, cyclin D3, MAFB. These translocations are unlikely to coexist with numerical abnormalities, which are present in the remainder of the tumors, in the form of mostly hyperdiploidy, with gains in the odd-numbered chromosomes (i.e., 3, 5, 7, 9, 11, 15, 19, and 21).
Flow cytometry can also detect in an aneuploid DNA content, which may be useful for post-treatment monitoring of residual disease. “Favorable risk” cytogenetics include the absence of unfavorable risk genetics and presence of hyperdiploidy, t(11;14) or t(6;14) by FISH. “Unfavorable risk” cytogenetics include deletion 13 or aneuploidy, hypodiploidy, t(4;14), t(14;16), or t(14;20), although the prognosis of some of these abnormalities is improving with new therapies. Abnormalities associated with disease progression include myc translocations and p53 (17p13) deletions/mutations. Bone marrow transplantation, autologous and allogeneic, is playing an increasing role in the management of patients with this otherwise incurable disease.
Copyright © 2017, 2013 Decision Support in Medicine, LLC. All rights reserved.
No sponsor or advertiser has participated in, approved or paid for the content provided by Decision Support in Medicine LLC. The Licensed Content is the property of and copyrighted by DSM.