Abstract
The detection of antimitochondrial autoantibodies (AMAs) is critical in the diagnosis of primary biliary cirrhosis (PBC). However, conventional laboratory assays to detect AMA are dependent on the time-consuming method of immunofluorescence microscopy, a method often plagued by problems of nonspecificity. AMAs react against mitochondrial autoantigens including the E2 components of the pyruvate dehydrogenase complex (PDC-E2), the branched- chain 2-oxo-acid dehydrogenase complex (BCOADC-E2), and the 2-oxo glutarate dehydrogenase complex (OGDC-E2). Interestingly, the immunodominant epitopes of PDC-E2, BCOADC-E2, and OGDC-E2 are all conformational lipoate binding sites, but antibodies against them do not cross-react. Although 80% to 90% of sera from patients with PBC react to PDC-E2, approximately 10% patients with PBC react only to BCOADC-E2 and/or OGDC-E2. We have taken advantage of our epitope-mapping studies of the E2 components of PDC, BCOADC, and OGDC, and constructed a 'designer' hybrid clone, designated as pML-MIT3, that coexpresses the immunodominant epitopes within the three distinct lipoyl domains. We examined a total of 321 sera, including 186 sera from patients with PBC, to test the immunoreactivity of pMIT3. Of 186 sera from patients with PBC, 152 sera (81.7%) reacted with recombinant fusion protein of PDC- E2, whereas 171 sera (91.9%) showed positive reactivities when probed by immunoblotting against the recombinant fusion protein expressed from the pML- MIT3 clone. Of 34 PBC sera that did not react with recombinant PDC-E2, 18 sera contained BCOADC-E2-specific AMA and 1 serum possessed only OGDC-E2- specific AMA. We also developed an enzyme-linked immunosorbent assay (ELISA), using affinity-purified recombinant fusion protein of pML-MIT3 clone as the antigen source, to quantify specific AMAs in patients with PBC. None of the 135 control sera from patients with primary sclerosing cholangitis (PSC), chronic autoimmune hepatitis (CAH), systemic lupus erythematosus (SLE), or healthy volunteers showed significant reactivity against pML-MIT3 recombinant fusion protein in the ELISA assay. Our results indicate that an ELISA using recombinant, cloned autoantigen of pML-MIT3 is a powerful and very specific method for the detection of AMA.