Essential oils may not always be so essential, say fragrant Davy philosophers
Laura Slattery
“Welcome to the world of flavour and fragrance,” a new Davy Research report on the flavour and fragrance (F&F) industry boldly opens. Written by John O’Reilly, Jack Gorman and Aiden O’Donnell, it’s easily my new favourite stockbroker research report – a heady mix of financial metrics and the philosophy of sensory pleasure.
First, the history bit. Over the last 20 years, the F&F sector has thrived as consumers smelled the bath salts, wrapped their tongues around flavour extracts and sought out those top notes with an enthusiasm that, while not unique in history, “has never before been so dominant, at least as far as so many people are concerned”, Davy argues.
“Nothing exemplifies this more than how the human body, as regards every sensory experience, has commanded centre stage as the means to self-awareness, gratification, emotional and psychological well-being, self-expression, self-creation, identity and personal happiness.
“It has been narcissism writ large.”
(I’m a Clinique Happy Heart woman myself.)
“In the long historical contest… between stoicism (indifference to pleasure) and hedonism (that satisfying wants and the pleasure attainable is the only good), hedonism has been the recent winner,” says Davy. Its report goes on to discuss the ideal conditions for fragrantly rampant consumerism, and how these may variously relate to Romanticism, the Industrial Revolution and a scene from Marcel Proust’s In Search of Lost Time, before reaching the more grimly prosaic austerity versus stimulus economic debate of our times.
“A regime of austerity will only endure if the belief system around it changes,” Davy observes. In other words, make-do-and-mend resignation won’t last unless we really, really believe in it. But if we do believe in it… then that has consequences for flavour and fragrance manufacturers like Givaudan (top shareholder: the Bill and Melinda Gates Foundation), Naturex, Robertet, Frutarom and Symrise.
These F&F houses fulfil the “here comes the science” role that L’Oréal used to talk about, buying raw materials like vanilla, menthol, sandalwood and citrus and transforming them into the chemical cocktails that make up shampoos, balms, perfumes, gels and detergents for consumer product companies – which then do the easy part and sell the stuff to us weak hedonists.
Bicarbonate of soda is an effective cleaning agent, the report notes, but it lacks the sensory attraction of a fragranced alternative. This is why it is so hard to purchase a clothes detergent that has not been jazzed up with the smell of fresh mountain air or sea shore driftwood – “as if these could ever really be put in a package”. The irony is that with so much olfactory bombardment, our sensory neurons get a bit tired. Because everything smells, nothing much smells – or at least not in a way that stimulates us.
This might not be a problem for much longer. If austerity overturns the existing order, then it’s curtains – in the West, at least – for what Davy calls “the excesses of a buy/discard/buy culture”. The “marketing bias towards engendering personal dissatisfaction” may have to be re-pitched; the “demand for novelty in sensory experience” will falter. The stockbroking house forecasts that industrial sensory experiences may well “be of lesser significance” in future, at least in the developed world.
Or as it puts it: “The long-run contest between the stoics and the hedonists may enter a new phase.”
So those essential oils might not be so essential any more. And that’s not great in an industry where new products can account for around 20 per cent of sales. Happily, Davy remains positive about the fundamentals of the sector – praise the lord of ylang-ylang for those developing markets.