A few weeks ago, MathWorks has added a new section on its website called the “Plot Gallery“. This section highlights specialized Matlab plots that were posted on the Matlab File Exchange (FEX) and can be used by Matlab users in their GUIs. Unfortunately, for the moment this list only includes some 20 customized plots posted by MathWorks employees, in addition to some 50 examples of using the standard Matlab plots. I have a suspicion that one day, if this proves popular, we will find the gallery integrated in the main Matlab Desktop, possibly next to the current plot selector component.
Since the Plot Gallery section is a new effort at reducing plotting complexity to Matlab users, I think that it should be encouraged by user feedback. Please feel free to leave them a comment with your feedback, either on this page, or on their semi-official blog announcement page.
My personal beef with the new Plot Gallery is the fact that it does not currently include user submissions. FEX actually contains numerous user-submitted specialized plotting utilities, answering a wide variety of needs in multiple discipline fields. These can easily be found using FEX’s search functionality or tags. For example, the FEX “plot” tag currently has 440 separate submissions. Perhaps one day these user submissions will be added to the Plot Gallery in some searchable structured manner.
One set of specialized plots that I’d like to highlight today is based on the open-source JFreeChart, that I have described here last year. Sven Körner has used this to provide a dozen different customized Matlab plots, a few of which can be seen below, showing the power of integrating external code in Matlab GUI. JFreeChart contains many more customizable chart, plot and gauge types so Sven’s examples should merely be considered as appetizers:
MATLAB-integrated dial gauge chart
MATLAB-integrated multi-axes chart
As well as
JFreeChart, JavaFX 2.0 Charts can also be added to MATLAB figures using a
JFXPanel. Those can be added to MATLAB containers in the same way as a
JPanelusing the undocumented javacomponent function (or derivatives like uicomponent and jcontrol from the FEX – see this blog for details from Yair (link)
You will of course need to put the JavaFX runtime from Oracle on the MATLAB javaclasspath ().
Hey Yair,
Amazing blog I read it all the time; I have a quick question about using the jzy3d library (Supposedly a good library for charts that are bit more complicated than those in JFreeChart, which I have gotten working with no problems). I have just been testing it and I am having difficulty getting a piece of code working. I added the following files to the static path:
org.jzy3d-0.9.jar
org.jzy3d-0.9-dependencies.zip
And ran the following code:
When I create the ‘chart’ object I get the following error:
Undefined variable “org” or function “org.jzy3d.chart.Chart”.
I have checked to ensure that the fully qualified name is correct and the constructor accepts no arguments.
Any help will be appreciated.
Thanks,
@Patrick – I’m not exactly sure, but you can look at Malcolm Lidierth’s recent FEX submission that demonstrates using jzy3d in Matlab. If you drill down in this submission’s internal m-code (which shouldn’t be too difficult), I’m pretty sure you’ll find the answer.
@Patrick
Some of the jzy3d dependencies (e.g. JOGL) are part of the standard MATLAB distribution and on the static javaclasspath – but not in the right version for jzy3d 0.9. Try using jzy3d 0.8.4 which worked for me – or update the dependent jars loaded by MATLAB.
@Malcolm
I tired using your submission on the FEX and I am able to create my example above, I’ll see what I can do about using 0.8.4. Thanks for your suggestions.