On August 31, 2012, here at YesYesNo and collaborators, one of our dreams was the project called "Connecting Light". There were hundreds of 2 meters wide weather balloons along the Hadrians Wall in England that lit up, translating written messages to light and color, and then sending these light and color messages across the landscape. You can find out more on the Connecting Light website if you wish to learn more about this project.
It was using Xbees to communicate with a 300 nodes mesh network across a very long distance. This time, we will be using wifi network instead and we found this nifty little thing called Spark.
In this Instructable, we will show you step by step on how to rewire the high power LEDs in order to get these lights online via Wifi.
Step 1: Spark Adaptor Board BOM and Tool List
BOM
- 2 Pin 5.08mm PCB universal screw terminal block connector * 1
- 3 Pin universal screw terminal block connector * 1
- Small Perf Board / prototyping board (here we use 1/4 size prototyping board from here)
- Single row flat female pin header sockets cut to size * 2
- Spark * 1
Tools You'll Need
- Solder Station
- Soldering Iron
- Flush cutter , I use Xuron
- Wire Stripper, I use Hakko
- 22 to 28 AWG soild wires in Red, Green, Blue, Black and White
- electrical tape like these
- 2mm flat head screw driver
- mini Glue Gun and glue sticks
Things good to know:
Perfboard is the term to describe a material for prototyping electronic circuits. It's also called prototyping board and so on.
Sparks Adaptor Board is what we are making here in this instructables.
Use the Right Tool is something that's always helpful, too...
Step 2: Connecting to the Light
Some basics to go through before making the Spark adaptor board:
These LEDs runs on 12V DC power and on the main board it has a voltage regulator that supply 5V to logic level - to any microcontrollers that uses 5V. The lights then communicate to the microcontroller -- in our case, a Spark, using three PWM pins.
In our example, we will use the 5V, ground, Red PWM wire, Green PWM wire, Blue PWM wire to Sparks adaptor board and then we will use a 3D printed piece to hold our new Spark adaptor board in place on top of the light.
Step 3: Make Spark Adaptor Board
Sparks has 12 pins on each side, here we want to make a Spark adaptor board that we can plug the Spark in or take it out if we need to replace the Sparks for any unknown reasons in life.
- First we will take the female headers and cut them into size. There 12 Pins on each side. So we need two 12 Pin female headers. Marcela found that using a Hakko cutter as shown in the picture does a much prettier job than a scissor.
- Line up the header pins as in the picture, on my perf board it sit at the row where 15A and 15F were.
- Solder the first and the last header Pins to secure the headers. We will go back and solder the rest of the pins.
Step 4: Add Connections for the Sparks
- We want to connect the PWM pins and 5V, ground between the light and the Sparks adaptor board.
- Fit the 3 Pin and 2 Pin screw terminal diagonally to fit on the perf board.
- Solder the screw terminals on to the perf board.
- Once you're done. Don't forget to solder the rest of the female header pins for Spark.
- After this you're ready to wire the lights to the adaptor board.
On my adaptor board, the red wire goes to Pin 1F , the green wire goes to 2G, and blue wire go to I3.
5V goes in the the positive line, and ground goes to the negative line.
Step 5: Wiring
- Cut the cables on the end close to the original Xbee Adaptor board.
- We are only using 5 wires here, that's the 5 wires from the left of the plastic housing on the main board -- the order is Red wire, Green wire, Blue wire, Black wire and grey wire. We are not using the two ground wires on the right. So you should cover the leads with an electrical tape so even the small wire end that's expose does not touch any SMD parts on the light's main board.
- Make the connections on the perfboard by soldering jumper wires between the pins and the screw terminal pins.
- screw the wires into the terminal blocks in order
- To be safe, hot glue the connections so it's strong and you'll never have to worry about loose wire again.
On my adaptor board, the connections are as following:
blue wires goes from 11J to 3I , it's connected to Pin A7 on Spark
green wire goes from 10I to 3H, it's connected to Pin A6 on Spark
red wire goes from 9H to 1F, it's connected to Pin A5 on Spark
grey wire goes to the + line on the perf board , it's connected to VIN on Spark
black wire goes to the - line on the perf board, it's connected to GND on Spark
Step 6: 3D Pinting Files for Makerbot and Cube
You can now download the files from Thingiverse
Step 7: Code