In June of 2018 one of my favourite Canadians, Melody Zacharias, invited me to write a chapter for a book she is publishing later this year called “Let Them Finish”.
[Edited 17 November 2018: You can buy the book on Amazon.com, and all proceeds go to charity.]
[Edited 4 July 2021: You can read the full chapter on Medium, with permission from the publisher.]
For context, Melody and other fine women in technology put together a book last year called “Let Her Finish”, with chapters written by women about technology with a focus on the Microsoft data platform. It was a technical book, explicitly apolitical except for the fact that the authors were women.
What made her invitation to me significant is that I’m not a woman. I can talk about my lived experience as a queer person all I like (and boy do I ever), but I’ll never be a woman. That was the first thing. The second is that I don’t think I mentioned one technical thing in my chapter at all.
Even months after writing the chapter I feel like my contribution is out of place. I say that because I got political. I even asked and was granted permission to curse in print. Contextually it makes sense, but it will offend some readers.
The thing about book chapters is that sometimes they come easily, and sometimes they need to be teased out. This chapter was of the latter variety. It required finesse. Unfortunately there was a strict deadline for inclusion, so I was only able to contribute 7,500 words or so.
For comparison, a few weeks ago I banged out 7,000 words over the course of two days for two technical blog posts.
Undoubtedly the book chapter is more important than those blog posts. While my essays about relational databases will gradually become obsolete, writing about human society and the acceptance of LGBTQIA+ people is timeless. After all, despite taking place several decades ago, the civil rights movements in the USA and South Africa respectively are still relevant today.
Writing about important things like human rights is challenging. I benefited from white privilege growing up in Apartheid South Africa, while avoiding what darker-skinned people have dealt with — and continue to deal with — in most countries around the world.
While lately I’ve also taken to rejecting gender labels, I look and sound male, which means I’ve avoided a lot of what women have to deal with. That is male privilege even if I don’t identify as such.
My position in the book chapter is to show that queer rights are human rights, but hopefully in a way that is respectful of the civil rights activists of the past and present. I cited Simon Nkoli, who spoke of being free as a gay man having equal weight to being free as a black man. I wrote about trans rights too, and I recognize that I am not black, nor do I know what it’s like to transition.
Writing about these issues is challenging because I have been given an opportunity to be published, to be listened to, above others who will never have that opportunity.
When the book is launched, I’ll also be publicly outed. Although I’m out to everyone, literally wear a Pride watch band, and correct people who assume I’m married to a woman, it’s very different when (to some people anyway) this is the only way they’ll know my name.
It’s a little scary. It’s almost as scary as walking through Hillbrow holding a Pride flag and risking people throwing rocks at you. At least there you can face the fear. This is more abstract.
You’ll have to buy the book to see how I do identify, but I’d really appreciate it if you don’t refer to me as “he”. You can use “them”, “they”, and “their” as my pronouns. If you can remember the name of your favourite Starbucks drink, you can remember something as simple as a pronoun. If you’re unsure, ask! Yes, this is a strange new world we live in and I get it wrong myself, even when referring to me. I also still use ableist and sexist slurs without thinking.
It’s hard to change how you speak, but it’s for the better. To paraphrase a legendary comment I heard many years ago, I hope my being queer doesn’t get in the way of you being straight and white.
Please buy the book. Please read it with an open mind. Please stop killing us.