What Med Students Learn From Sticking With Their Patients
Altaf Saadi, a Harvard Medical School student doing an "integrated clerkship" at Cambridge Health Alliance
Medical school is an infamous time of maximal stress, as a student bounces quickly from specialty to specialty and patient to patient, building emotional calluses. In a fascinating interview just out in The Boston Globe about medicine’s tendency to “dehumanize” doctors, Dr. Omar Sultan Haque says, “Empathy decreases as you get more experience with patients. The nicest people you’ll ever find who are doctors are in the first two years of medical school.”
But what if it doesn’t have to be that way? At least, not all of it? A study just out in the journal Academic Medicine reports positive findings on a different model for the third year of medical school: Students follow their patients “longitudinally,” through all their treatments, even from hospital to home.
The study of third-year students in Harvard Medical School’s “integrated clerkship” at Cambridge Health Alliance found that they scored just as well as their peers on standardized tests, but they felt differently about their experience. They saw it “as more humanizing (even transformational) and less marginalizing than do their peers in more traditional clerkships. Strikingly, these strongly positive perceptions exist in the face of an experience that is described as both more hectic and more stressful than the traditional clerkship.”
Here, Altaf Saadi, a third-year Harvard medical student currently participating in the Cambridge Integrated Clerkship, describes what it’s like to have real time to spend with a patient who is going through cancer treatment and navigating the medical system.
By Altaf Saadi
Guest Contributor
This Monday, my internal medicine supervising physician and I saw Helen’s bald head for the first time. “Do you want to see it?” she asked. And, with our encouragement, she slowly removed her caramel-colored wig.
“You two are the first people to see my head like this.”
She was in her third cycle of Cytoxan and Taxol — two chemotherapy medications for treatment of her breast cancer — and she had lost her hair, among a dizzying number of other side effects she has experienced. So we sat there in the primary care clinic, weathering the initial influx of pain, bearing witness to her experience of cancer.. Traditionally, third year medical students complete discrete “block” rotations in core disciplines such as Internal Medicine, Pediatrics, Obstetrics, and Surgery. They rarely see patients more than once. As part of the Cambridge Integrated Clerkship, we instead spend time in all of the disciplines throughout the year by following “our” patients through those disciplines.
What that has meant for my relationship with Helen, for instance, is that I met her shortly after her initial cancer diagnosis, accompanied her to her surgery, saw her for five weeks of radiation therapy and now through her chemotherapy. At the same time as I interacted with her breast surgeon, radiation oncologist, and medical oncologist, I also worked with her primary care physician to manage her hypertension and a social worker to help her obtain health insurance.
Because of this experience, what I learn in medicine has taken on a whole new meaning. As I go to check in with Helen at her chemotherapy infusion appointments, for example, watching the Cytoxan and Taxol flow from the IV bag, into the tubing, and into Helen’s right arm, the side effects I have memorized are ones I seriously dread. Overpowering, bone-breaking fatigue, blackening of nails, hair loss, acne-like rashes, and taste changes and nausea so bad that it stops her from eating — these are all thing that have actually happened to Helen. I sometimes hear them in her voice when I call and speak to her on the phone. They are also some of the many hurdles on a long, harrowing road of treatment.
I’ve also gotten to see how confusing and scary the American medical system can be for patients to navigate. Helen does not have the best health literacy. She calls me when she has upcoming appointments to make sure I will be there so I can translate the obscure medical jargon some physicians use. I have also gotten used to appointments when she will respond “No” to the physician asking “Do you have any questions?” but then will flood me with questions minutes later when we step outside the doctor’s office.
I have learned most of all from my patients. They bare their hearts to me, and they make me privy to their innermost confidences.
I’m not sure I would have gotten this perspective had I not been invited to share hers through the Cambridge Integrated Clerkship program. I have also learned the importance of providing reassurance to patients, often repeatedly. Her biggest fear going into surgery was that she would be put to sleep forever from the anesthesia. These are real fears patients have, fears that often do not get communicated when relationships are not established with patients.
I have other patients who I have seen multiple times too, some up to 30 times. I am reminded, day in and day out, how fortunate I am to be a doctor-in-training in this innovative model for medical education — a model based in relationships and commitment. In addition to learning from the formative, yearlong relationships I have made with my supervising physicians, I have also learned most of all from my patients. They bare their hearts to me, and they make me privy to their innermost confidences. Daily, I experience and share an inside connection with humankind, joy, courage, life, and death.
The greatest privilege, at the end of the day, is that I can make valuable contributions to their health care as I learn from them. I will never forget noticing the following lines from Helen’s chart last winter: “Patient feels grateful and shared with this writer that when she was awakened from surgery she saw the face of the medical student smiling at her… She will never forget that smile.” I will never forget yours either, Helen.