In Signs and wonders: Dispatches from a time of beauty and loss, Delia Falconer looks for ways to describe how modern and developed societies are increasingly captivated by nature as we wipe it out. One of the nicest offerings is ‘skying’, English artist Jon Constable’s term for the hours he spends lying on the earth, staring at the clouds he will paint later as they pass through the sky. over his head. Language lover, Falconer borrows the term to describe her long walks and amateur photography during Sydney’s first COVID lockdown.
Indeed, the entire collection, with its diary entries, images, vignettes and multipart essays, can be seen as a “skying” process. With his keen, empathetic eye, Falconer creates a moment of stillness to observe the constant, inexorable movement of the world around us: a movement toward ecological disaster caused by man-made climate change.
Fragments captured by Falconer include howling bees as their hives burn in bushfires and moaning glaciers as they melt; an off-leash dog trying to play with a fur seal; and luminous jellyfish wrung out in an attempt to bottle their sparkle. Our desire to interact with what we lose in many cases only accelerates the decline, as does the intensity of our anxieties.
Everything falls apart, including, as Falconer points out, the narrative.
The collection’s subtitle identifies it as a series of “dispatches”, evoking not only official reports, but also a necessarily uneven presentation. That’s why Falconer collects new words and experiments with form: it’s too late for a consistent account of what’s going on.
Like “skying,” other borrowed terms inform the collection on a deeper level. The respectful yet melancholy tone and unexpected approaches reflect human feelings of “solastalgia” (Glenn Albrecht) or “end sickness” (Elizabeth Rush), physical sensations felt in response to familiar environments changing around us.
A more bittersweet concept is that of the Yolngu people bir’yun, or “shimmering”, which are the interconnections and agency of the natural world without the human point of view as a foundation. In a sense, Signs and wonders is itself an act of “shimmering”, with all of its accompanying connotations of light, brilliance and clarity. The only problem is, as Falconer notes, that human impact is now almost impossible to root out even the smallest and most remote ecosystems.
Read: Theater review: Coming soon, QPAC
There are times when the relationship between the subjects seems fragile, or takes a while to become apparent, usually when the focus begins with aspects of culture and the arts. But that’s how Falconer sees the world: as a reader and a writer. His skills in these areas allow him to explore, for example, the use of light in the television show CSI: Las Vegas and change the approaches of the fictitious paragraphs in a precise and enlightening way before returning to the central concern of the work: that it is about “the charismatic phase of the environmental collapse”.
As the world rushes towards the inevitable, Falconer offers space to reflect on where we’ve been and where we’re headed – tragically -. No mitigation solution or strategy is presented, but that is not the subject of this collection. Rather, it is a simultaneous act of “skying” and “shimmering”.
Falconer herself confesses that she doesn’t know if Signs and wonders is ‘a disk or a requiem’. Maybe in the end it will be both.
Signs and Wonders: Dispatches of a Time to Beauthority and loss
Through Délia Fauconnier
Publisher: Scribner
ISBN: 9781760857820
Format: Paperback
Pages: 290pp
Release Date: September 29, 2021
List price: $ 32.99