Creating Industry-Funded Research
The trend toward increasing competition for revenue and consolidation and the resulting need for new operating models and relationships is not unique to business. Horticulture academia is also going through similar challenges. As we have progressed from an agrarian society with agriculture at its core to an urban clientele that is serviced by a mature and global agricultural industry, one side effect has been a decline in applied research funding for horticulture.
These realities also create new opportunities for leading researchers to partner closely across universities and with companies that value research and development. In 2004, the Young Plant Research Center (YPRC) was created as a team research program that aims to be:
“A leader in team-based research, developing solutions for real industry problems, focused on nutrition, plant health, technology and genetics for the production, propagation and shipping of young plant material.”
This industry-funded group of researchers works closely with leading businesses to come up with new information especially relevant to rooting stations, stock plant producers and media companies. Because my wife, Rosanna Freyre (a flower breeder), and I recently left the University of New Hampshire for the University of Florida, the YPRC program is now centered in Florida but continues to have collaborators in several states.
The YPRC
In 2004, we established a consortium of growers and allied companies that each donates $10,000 per year to the program. By 2006, this group had grown to include these leading, independent greenhouses: Center Greenhouse, Denver, Colo.; D.S. Cole Growers, Loudon, N.H.; Four Star Greenhouse, Carleton, Mich.; Glass Corner, Grand Rapids, Mich.; Kube-Pak, Allentown, N.J.; Lucas Greenhouses, Monroeville, N.J.; Pleasant View Gardens, Loudon, N.H.; and Welby Gardens, Denver, Colo. Industry supply partners have a media and nutrition focus, and include Blackmore, Ellegaard, Greencare, Premier Horticulture, Quality Analytical Labs and Sun Gro Horticulture.
In addition to this core group, we also do contract research and development and collaborate with other propagation-related companies, and we have received funding from the American Floral Endowment for projects related to the YPRC.
Our model of collaboration is “co-opetition.” We emphasize that partner companies are competing for sales in the marketplace but not research; rarely is there one nugget of unique and secret technical information that is the point of competition and business success. From the university side, collaborating with multiple companies makes it easier to remain objective, and we gain insights into real industry priorities and innovative practices.
One benefit for our research partners is they help set priorities each year (see side bar, below). Partner companies also have a chance to discuss and participate in early research results. Our theme for 2006 was, “Taking Research to the Grower,” and many trials take place on growers’ locations. We work hard to make each company’s investment in research worthwhile, with a mix of short- and long-term projects.
Who Is YPRC?
The YPRC team is comprised of members from a variety of universities and professional positions from around the United States. The members of the YPRC team are:
University of Florida:
- Jim Barrett. Plant growth regulators and hormones.
- David Clark. Molecular biology, genetic engineering and flower breeding.
- Paul Fisher. Program leader, nutrition and technology.
- Rosanna Freyre. Flower breeding and genetics.
- Jamie Gibson. Nutrition, propagation and tropical plants.
- Terril Nell. Post harvest.
Collaborators from other universities:
- Raymond Cloyd, Kansas State University. IPM and fungus gnats.
- Alan Eaton, University of New Hampshire. IPM and fungus gnats.
- John Erwin, University of New Minnesota. Growth and flowering.
- Susan Han, University of Massachusetts. Post harvest.
- Cheryl Smith, University of New Hampshire. Pathology and post harvest.
Support staff :
- Jinsheng Huang, University of New Hampshire. Nutrition and soil chemistry.
- Joe Vasquez, University of Florida. Greenhouse manager.
- Kate Santos, University of Florida. Graduate student, nutrition.
- David Dobos, University of Florida. Technician.
- Erika Williams, University of New Hampshire. Technician.
The YPRC is not the only team research program that works closely with the industry. We coordinate with another consortium called the P3 research program run by Clemson, North Carolina State and Michigan State Universities. P3 is doing cutting-edge research on post-harvest issues for unrooted cuttings and is funded by cutting producers and breeding companies.
Looking Ahead
The theme for 2007 is, “Collaborating for Knowledge and Profit.” This coming year will see a strengthening of ties among universities working in the group. For example, Erik Runkle (Michigan State University), John Erwin and I will be working together on crop scheduling tools for growers. This project takes advantage of climate control facilities and physiology skills at Michigan State University and the University of Minnesota along with experience at the University of Florida in developing grower software. This North-South collaboration provides a range of very different environments in which to compare crop finish times.
The research group will continue to expand slowly so we can maintain a high level of research quality and client service. Additional Florida growers, including Knox Nursery, Winter Garden, Fla., and the Pindstrup media company, are coming on board in 2007.