The phrase “astrological diatonic theory” probably pops out in your mind and immediately piques interest. It may be your first time coming across it, as it’s a concept I coined myself. Granted, I didn’t invent diatonics or astrology; rather I thought of combining the two. So might I really be on to something or is it just fancy language?
So what is meant by this phrase? I will start with astrology. The simplest, most shallow understanding of astrology is that it’s the study of the constellations and stars. Some might argue it’s just the study of horoscopes, personalities, or relationships. But those with a graduated understanding of astrology connect its theories to spirituality. And at the center of everything is frequency, as is contended by modern erudites. Corroborating this claim is our developed understanding of physics and the atom.
I’m not much of an expert on astrology, as I am in my early stages of study, but I do have knowledge of music theory and the science behind it. I’m no physicist either, but I happen to know a little when it comes to sound and frequencies. The science of physics doesn’t reach into ones soul or fill them with excitement in the same way that music does. Musical understanding and musical affinities seem to be innate in everyone. You might not be able to explain why you like a tune or why you can immediately sense that someone played the wrong note, but something innate accurately informs your perception. So the advantage, in my opinion, that music has over physics (not that they are actually two different things), is that music is largely built off feeling, while physics might be better described as being more soulless with no guidance. This could be why physicists don’t have all the answers yet. What I’m getting at is this: When studying frequency through music, spiritual, profound, or significant discoveries can be sensed, while physics attacks with the opposite approach, expending a massive amount of time and effort, hoping to strike gold.
Now that that’s out of the way, let’s talk about the diatonic scale of music. Before we had the hard science that we do today, the great composers mapped out a wonderful theory of music by ear. Of course, a little bit of science was involved, but the human element was dominant and offered the most guidance. In fact, discoveries by the human ear arguably informed the science of music. This speaks to my point from earlier, which is that we are innately programmed to understand and interpret music. And just what is music? Well, broken down scientifically, music is an arrangement of frequencies, ideally in an ordered harmony. Every musical note is associated with a particular frequency, and musical instruments are built with an understanding of frequency division. As an example, the diatonic scale, consisting of 12 notes, is completely grounded in mathematics.
What’s special about the diatonic scale is that it’s the most dominant scale in the world. Most music theory revolves around it. Mozart used it, Beethoven used it, Bach used it, etc. Scales with both more and less than 12 notes have been constructed, but the 12 note diatonic scale is the one that has stood out. It symbolizes something much greater than we understand, yet as we cannot explain it, we innately sense something about this scale that is very powerful.
OK, so what am I getting at? This music theory knowledge is nothing new to me. What was new to me was that the astrological chart has a specified order of signs. And that specified order of signs consists of 12 signs. That’s when it hit me. Both music and astrology are theorized based on 12 orders, and they are both based on frequencies. What are the chances it’s just a strange coincidence?
The astrological chart is popularly depicted as a circular diagram that loops.
The same is true about the overarching theory of music called the circle of fifths.
I think there is a cosmic connection here that we are missing, and there could be a lot to the number 12. So I hope this was explained well enough as a primer into this concept. This is a topic I will be exploring further in the near future.