Best way to manage config file?
A colleague and I discussed best practices for managing the config file, and we wanted more information from others.
Our goal is for the configuration file to dictate what action to take when certain events occur.
The 2 options we are discussing:
In the configuration file, specify the class-class of the class that implements the action to be taken (for example: "ActionToTake": "com.company.publish.SendEveryoneAnEmailClass"). Inside the code, when this event is encountered, we can then execute Class.forName (config.ActionToTake) .newInstance (). Run () to invoke the specified action.
In the configuration file, specify in a readable phrase the action to be taken (for example: "ActionToTake": "SendEveryoneAnEmail"). Internally, when this event is encountered, we can then parse config.ActionToTake and do a mapping that translates this into an action implementation (ex: new SendEveryoneAnEmailClass (). Run ())
We are currently a very small team and the only people reading / using this config file at the moment are our software development team. But it is unclear if this will continue in the future.
Rationale for Option 1: Anyone who reads the config file will explicitly and immediately know which class will be called and where it will be implemented. It also allows us to implement / import an action class from a completely separate JAR file without recompiling / modifying our code.
Rationale for Option 2: The configuration file should be a high-level user-level description and should not contain implementation details such as specific class names and package paths. Refactoring of class / package names can also be done without having to make changes to the config file.
Thoughts on which of these two design concepts are preferred for config files?
source to share
The advantage of option 1 is, as Yas pointed out, the ability to "link" the code in the future. This is a real benefit only if you sell / distribute your software as a proprietary package or if you plan on hot swapping behavior in production. You have already indicated the minus - refactoring
Second option:
- It won't help you with refactoring. If you change your action from SendEmail to BringBeer, but you leave the string
send email
, then you will fail.
- readability.
send-everyone-an-email
not worse
SendEveryoneAnEmail
. Every developer will know what will happen. It should not be confused with
LaunchRockets
. Your code can find the class based on some text, not necessarily the full name. Your code may assume actions are in a specific package unless explicitly stated. And this is a way to combine both options.
Consider another possibility: do the configuration in code. If you don't want to recompile the package, you can use the scripting language (groovy). It allows you to create very readable dsls and you will have refactoring.
source to share