We.
When we browse the web, several third-parties are able to snoop on the connection between the user and the website, including the user’s ISP, law enforcement, the website’s ISP, and other people in between.
Who can snoop on your connection without HTTPS, and what can they see? (by The TorProject)
These intermediaries are able to obtain and modify on the fly most of the information sent through the connection: the website reached, the web page name and content, the potential username and password, the user’s IP address, and more. It obviously poses a lot of problems, which is why HTTPS is now mandatory for more and more websites (public sector, banks, etc.). Using HTTP with SSL/TLS (HTTPS) hides much of information compared to the picture above:
Now, the intermediaries only get access to the website reached and the user’s IP address. The web page name, its content, the logins are no longer exposed to whoever snoops between the user and the website. It’s also no longer possible to modify this data on the fly.
The security gain is then huge, as it’s possible to transmit sensitive data in an authenticated way without being modified. This is possible thanks to a chain of trust established between the user software (a web browser, for instance) and a third-party who authenticated the service (a website, for instance).
This third party is called a Certificate Authority (CA). There currently are a lot of different CAs and all of them need to strictly follow the guidelines in order to stay trusted by web browsers, operating systems, and other software.
Once a service requests a certificate to be authenticated, the Certification Authority proceeds to a multiple-step process in order to verify the owner identity. If it’s successful, the service will be authenticated.
A widespread adoption
However, despite the huge benefit of using SSL/TLS, anyone who requests a trusted certificate for a specific domain needs to regularly pay an expensive fee, which slows down the adoption rate.
In 2014, a new non-profit Certificate Authority was created by the ISRG with the idea to provide trusted certificates for free for everyone. The adoption was huge: Let’s Encrypt has been publicly launched in 2016 and has already delivered more than 33M certificate since then, for more than 40M domains.
For the first time, more than 50% of total web page requests have been served over HTTPS in early 2017 and it’s still climbing.
This widespread adoption is definitely good news for security. However, the landscape evolves very quickly, with involved parties trying to fix the remaining problems—and introduce new ones.
Web browsers pushing harder
In order to push the adoption much further, web browsers are also taking active actions.
Recently, Google and Mozilla announced a new feature in their browsers (Chrome and Firefox, respectively): websites served over HTTP will be labeled as non-secure (whereas before HTTP websites used to be the norm and only websites served over HTTPS had a specific label):
They also announced the end of support for the SHA1 algorithm, which is still used by some Certificate Authorities despite several flaws it suffers.
Another step is the introduction of Certificate Transparency, the support of which will be mandatory for all Certificate Authorities from October 2017 in order to very quickly detect wrongly issued certificates and malicious Authorities, thus, revoking them as quickly as possible.
Last but not least, they are taking strong positions against Certificate Authorities that don’t follow the rules and best practices: Google and Mozilla announced their intention to distrust the “Class 3 Public Primary CA” Symantec certificate due to several failures to comply with the industry rules and other more recent security problems. This will revoke the trusted chain and will trigger a warning for users visiting a service authenticated with this certificate and may even block them to visit the website depending on their configuration unless Symantec changes their practices or agree to comply with Google and Mozilla requests which may be the case.
Security software playing nasty
- On 12 famous and widely used corporate middleboxes tested:
- 11 weaken connection security (compared to an up-to-date web browser).
- 5 introduce several MiTM flaws
- 10 support RC4 ciphers (broken)
- 2 support export-grade ciphers
- 3 do not properly validate the certificates
- On the various security software solutions and malware tested:
- 10 introduce several flaws (CRIME, anonymous ciphers, no certificate validation, RC2, too short DH length)
- Some RCE vulnerabilities (triggered by malformed certificates) are regularly found in some of them
Conclusion
The post HTTPS… Everywhere! appeared first on Malwarebytes Labs.
Source:: Malwarebytes