Chin.
About 250 community land trusts exist nationwide, but the Chinatown Community Land Trust, which held its kick-off meeting Jan. 14, is the first one to form in Boston since 1989, when Dudley Street Neighborhood Initiative established Dudley Neighbors Inc. in Roxbury.
Community land trusts operate as nonprofit community boards, acquiring land in order to ensure community control of development. Residents can still own or lease the buildings on CLT land, but the trust owns the land. CLTs have authority to designate housing as permanently affordable or deed-restricted to keep rents and resale prices from shooting up with a rising market. Homebuyers can accumulate some equity and benefit from greater stability and less vulnerability to predatory lending practices and foreclosures during housing boom-and-bust cycles.
“The idea of the land trust is the community owns it, and can preserve it for long term affordability,” said Suzanne Lee, former principal of the Josiah Quincy Elementary School, a Chinatown resident and a board member of the new land trust. “It’s a tool we can use to preserve our neighborhood.”
Community control over affordable rents and deed restrictions helps curb the loss of low- and middle-income residents that often comes with the gentrification of formerly low-cost neighborhoods — a key concern in Chinatown.
According to the Chinese Progressive Association, which helped incubate CCLT, the number of housing units in Chinatown has nearly doubled since 2000, but the lion’s share of the increase has been in the form of high-end market-rate units. The encroachment of luxury developments is leaving few options for lower-income Chinatown residents, said Karen Chen, CPA’s organizing director, and threatens the very fabric of the community.
“If working families and new immigrants can’t settle here, then it’s meaningless to have a Chinatown,” Chen said.
Of particular concern to the Chinatown trust are the neighborhood’s old brick row houses. These modest buildings, many of them owned by Chinese families, have traditionally provided housing for low-income workers. They have fallen into disrepair, causing untenable expenses for some owners, and they are starting to catch the eye of developers.
CCLT board member Lawrence Cheng, an architect and planner involved in Chinatown community master plans as far back as 1980, said the row houses were late in receiving attention.
“We’ve always been working to keep affordable housing in Chinatown, but in 2000 and 2010, we didn’t think enough about preserving these row houses,” he said. “[Now,] with development pressure around Chinatown, we feel we need to act.”
He added, “Someone with a good heart could buy [the row houses] and rent them out at an affordable rate — but we haven’t seen that happening, so we think CCLT is a way to achieve that.”
Lee, Cheng and others said Dudley Neighbors Inc. has been a key source of help and advice in how to form a CLT. The two CLTs are starting out in quite different circumstances, however. When DNI was formed 25 years ago, Roxbury contained a large number of vacant land parcels, neglected and in some cases arson-ravaged. The land had little monetary value, and the city granted DNI eminent domain to acquire more than 30 acres of land in the Dudley Triangle, which it still controls today, along with a few more parcels added over the years.
DNI has filled once-blighted lots in the Dudley Triangle area with playgrounds, a farm, gardens and affordable housing, including owner-occupied, cooperatively owned and rental units.
By contrast, for CCLT in 2015 the challenge will be to acquire land bit by bit in a densely-built, increasingly-pricey area.
A big task right off the bat will be reaching out to row house owners to educate them on the option of selling to the land trust or partnering with CCLT to finance home renovation. Many owners are first generation immigrants wanting to make a good profit and pass the money along to the next generation. In other cases, the buildings have been inherited by second or third generation family members who no longer live in Boston or who can’t afford needed repairs.
Jeff Hovis, a Chinatown homeowner and president of the CCLT board, explained that the CCLT aims to offer row house owners a competitive price.
“We are hoping the math can work, where we can make a deal favorable for both the land trust and for the current owner,” Hovis said. “They would be helping to preserve Chinatown, as well as getting a fair price.”
As of now, the fledgling land trust owns no land. There is some seed money to start acquiring property, but much funding is still needed.
CCLT tried recently to buy a row house on Hudson Street. But when the sellers, who had been struggling for some time with repairs ordered by city inspectors, held an open house, a developer walked in with a cash offer and the sellers took it.
This loss of opportunity underscores the uphill battle a CLT faces in a hot market with developers eager to swoop in.
“We just have to keep learning, and work to make our offers faster,” said Cheng, who said CCLT’s offer had actually been slightly higher than the developer’s cash offer.
Over time, if CCLT succeeds in acquiring a good number of properties, the hope is that Chinatown could hold onto a core of middle- and low-income housing and remain a place for new immigrants and low-income workers to gain a foothold and raise families.
For Karen Chen at CPA, that dream can’t come soon enough.
“Something needs to happen right away,” she said last week, exhausted after spending a good part of several days assisting and calming the alarmed Chinese-speaking tenants of the Hudson Street row house, who see the new owner’s representatives and workers coming in and out of the building and worry they will soon have to move. Chen continued, “It’s hard to be patient when someone is literally about to be thrown out, or facing a huge rent increase. We’re seeing this on an everyday basis.”