09-15-2011 05:52 PM
Hi,
I have a question concering obtaining multiple DAQ readings from a single device. I am reading the values of several thermocouples using an NI 9213 device (which has up to 16 TC lines). In my attached Labview code, I am taking in the values of two different thermocouples (one is being used in a PID controller, the other simply measures temperature at another point and writes the data). However when I try to run this VI, I get the following error:
"Error -50103 occurred at DAQmx Start Task.vi:5
Possible reason(s):
NI Platform Services: The specified resource is reserved. The operation could not be completed as specified.
Task Name: _unnamedTask<D5>"
I know this has something to do with the hardware internal clock, since I am re-using it multiple times for different data readings, but I am not exactly sure how to get around it. I saw on a separate post that I might have to merge all the DAQ readings into one task and then run Start Task once? Is that correct, and how would I go about merging them?
- T
09-15-2011 07:20 PM
09-15-2011 08:25 PM
Yes, I actually did a little bit of searching before asking my question. It seems that merging my DAQs into a single task should eliminate this error, but I am a little unsure how to do this.
If you look at my code, I currently have two DAQmx VIs running. One is a DAQ Assistant that is reading a thermocouple, and the other one is a Create Channel where values will be written to a counter PWM output. Both of these occur outside of a while loop, and the latter VI is the one that the Start Task VI is wired to.
In addition to these two measurements, I have several other thermocouples that I would like to read and record measurements from. I want to turn these TCs on/off at will using boolean switches, so my idea was to use sequential case structures where one task (and its error) would be wired to the next, etc. But I am unsure where to insert these additional DAQ measurements (within the while loop, immediately after I update duty cycle in my PID controller?). I thought I would have to Start my task after all of the thermocouple readings were incorporated, but since I am doing these measurements every second, would my Start Task have to be inside the loop as well? Does that work?
Or would it be easier to change my DAQ Assistant VI to read multiple channels? In that case, I am unsure of how to select which channel to read from in each of my case structures (since I have to write each reading to a different spreadsheet column every second).
I am sorry if this seems overly complicated, but my program is designed to do a multitude of things (because a complicated Labview program is UNHEARD OF).
- T
09-15-2011 08:46 PM
I have actually tried reconfiguring the DAQ Assistant to now read multiple thermocouples, and I get an error saying that I must change my DAQ Read.vi (which initially only read the first TC) to a multiple-channels type of DAQ. However when I do that and select N-channels 1 sample, the output is a 1D array (which I'm assuming has the current readings from each thermocouple in an array?).
Would I now be able to select specific values using something like the Index Array function? That way all my measurements are now in the same DAQ Assistant, and I can call the values one at a time without error.
- T
09-15-2011 09:20 PM
Yes. N channels 1 sample will give you a 1-D array where each element represents a channel. Index array will get you each element of the array.
This site uses cookies to offer you a better browsing experience. Learn more about our privacy statement and cookie policy.