Schwab’s 2014 benchmarking study found that RIAs achieved record growth and profitability. Jonathan Beatty, a senior VP at Schwab Advisor Services, was quoted in the study’s report saying, “Robust new client acquisition and expanded share of wallet with existing clients were the primary drivers of organic growth and underscores the power of the independent model and the continued demand for unbiased advice among investors.”
Against this backdrop, independent RIAs face challenges from large firms that bundle more and more services for high net worth clients while robo-advisers attack the investing interests of the Gen X and Millennial generations.
Where the Money Flows . . .
The combination of strong industry financial performance and burgeoning wealth transfers fuels a bright spotlight. Because money flows to where the opportunity is, private equity is pouring into financial technology and firms facilitating an adviser’s independence.
. . . And Where Competition Lives
A competitive industry is revealed when a firm, offering a new service or approach that generates energized demand, finds—within a short time—other firms doing the same thing (and even a little better). This one-upmanship advances industries, but leaves underfunded firms behind as formerly premium services become commodities and are used as loss leaders packaged with the new services. Inevitably, profit margins compress.
We see this across wealth management as specialties such as trust and estate law (trust services, charitable planning, estate planning, etc.) or tax planning are brought in-house by large firms as bundled services for the high-end market. Meanwhile, the low end of the market is pitched with off-the-shelf, technology-based services (LegalZoom, TurboTax, etc.). The robo-adviser is touted by some as a similar threat to RIAs.
Reaching for the Next Generation
In its 2014 benchmarking study, Schwab clearly noted the vitality of the independent RIA model, and, this is affirmed by the marketplace as the preferred model not only for current retirees and baby boomers, but also for Gen X and Millennials (albeit with desires for different service delivery approaches and professional interactions).
To attract the next generation clients, top tactics being executed by RIAs are (according to the 2014 Schwab Independent Advisor Outlook Study):
Demonstrating [a] firm’s expertise and services: 91%
Ability to communicate with [the next generation] using tools or channels they prefer: 85%
Having a strong reputation based on firm reviews and center of influence relationships: 83%
Offering a unique service or value proposition: 83%
Clearly communicating the benefits/differences of the RIA model: 83%
A Path to a Certain Future
For the small- to mid-sized RIA, having a robust competitive strategy requires hitting the greatest threats with neutralizing weapons. Two competitive strategies fit every independent RIA’s processes and are within every firm’s capabilities—service expansion through professional collaboration and a proprietary robo-adviser.
Professional collaboration. Only firms with substantial AUM can afford to hire staff specialists for trust, estate, charitable, tax, and insurance planning and execution. For small- to mid-sized firms, a team of independent but like-minded wealth management professionals (such as advisers, T&E attorneys, CPAs, and insurance agents) is an appealing solution for all generations, and preferred among clients between 30 and 45 years old, according to Schwab.
These collaborative relationships allow an RIA to offer expanded—and expert—services without the staffing overhead. By forming these relationships, each firm in the collaboration gains client acquisition leverage that otherwise would be expensive to attain separately (see “Achieving Higher Growth with Multidisciplinary Teams” from the March 2014 issue of the Journal of Financial Planning).
Robo-adviser. The robo-adviser is here to stay as a solution. RIAs that build a proprietary robo-adviser package (56 percent of RIAs believe that a robo-adviser offering could supplement the firm’s current package and help the business grow, according to Schwab) will gain leveraged access to three important market segments:
- Low-asset clients seeking professional guidance
- Those who are fee sensitive but desiring periodic expert oversight
- Children of current clients who lack the AUM to be managed profitably (Note: Schwab’s study discovered that the vast majority of RIAs lacked a coordinated relationship program with clients’ adult children; this puts the firm’s long-term valuation at risk.) See my previous blog post, “Building Generational Bridges Protects Your Firm’s Value” for more on this.
Act to Compete and Compete to Win
The wealth management industry is highly fragmented. Consequently, a firm’s long-term viability arises from astute and pointed tactics aimed at competing and winning in local markets. Small- to mid-sized RIAs can seize the competitive agenda from larger and better funded competitors by offering comprehensive services (via professional collaborations) and expanding to underserved markets (via automated advice/robo-adviser technology). Doing so keeps the future looking just as bright as it is today.
Kirk Loury
President
Wealth Planning Consulting Inc.
Princeton Junction, New Jersey
Pingback: Wealth Planning Consulting, Inc. | Neutralizing a Client’s Negative External Influences
Pingback: Practice in Action! | Neutralizing a Client’s Negative External Influences - Practice in Action!
Pingback: The Balance Sheet Methodology (BSM) | Neutralizing a Client’s Negative External Influences
Pingback: Neutralizing a Client’s Negative External Influences – Avenue Robo-4-Advisors