AUSTIN, Texas—Ecologists from around the world are finding provocative signs that global warming already may be altering the Earth's flora and fauna. And they worry that next century, when the climate is expected to change more abruptly than it has in at least 10,000 years, plants and animals will be pushed to the limit.
If the Earth heats up, will animals seek cooler habitat? That is one question scientists ask to help gauge potential biological effects of climate change. Now, butterflies are yielding some answers.
Dr. Camille Parmesan, a biologist at The University of Texas at Austin, and 12 other international researchers studied 35 species of non-migratory butterflies whose northern boundaries were in northern Europe and whose southern boundaries were in southern Europe or northern Africa.
The researchers took into account shifts in land use and loss of habitat, and discovered that 63 percent of the butterflies have ranges that have shifted to the north by 35 to 240 kilometers during this century, and only 3 percent have shifted to the south. The two-year study, results of which will be published this week in the British journal Nature, is the first large-scale evidence of poleward shifts in entire species' ranges.
Given the relatively slight (0.8 degrees Celsius in Europe) warming in this century compared with predicted increases of 2.1 to 4.6 degrees Celsius for the next century, future climate warming could become a major force in shifting species' distributions, Parmesan writes.
Although her work on butterflies incorporates the most complete data set to document this type of range shift, other (smaller) studies from around the world also are indicating northward movement of species' ranges. If studies on the ranges of dissimilar species over many geographic regions continue to reveal similar trends and patterns, then a conservative conclusion would be that the currently detected levels of global and regional warming are affecting the ability of organisms to live in their traditional habitats.
Based on the response of butterflies to past changes and fluctuations in climate, Parmesan and colleagues predict those species that cannot move to new habitats to keep pace with climate change will die out. These changes will be exacerbated because the existence of new habitat for butterflies to move into is likely to be much more severely limited than during historical climate shifts because potential habitats are being rapidly taken over by humans, particularly by urbanization and changes in the natural landscape for agricultural purposes.
Research on the European butterflies replicates an earlier study by Parmesan of 151 populations of the Edith's checkerspot butterfly that demonstrated that in the past 100 years, the sensitive insects slowly have been moving northward or to higher altitudes, from warmer to cooler climates.
The orange-and-black butterfly can be found in much of western North America; it is dying out at its southernmost limit in Mexico and doing well in Canada. Parmesan calls the finding "exactly what has been predicted will happen with global warming; it indicates that the changing climate is already influencing species' distributions."
Edith's checkerspot butterfly is prized by collectors for the distinctive orange and black patterns on its wings — which, folded together, are the size of a pair of postage stamps — and by ecologists because it is especially sensitive to subtle climate changes.
Parmesan, whose study was conducted while she was a graduate student at UT Austin, found rising temperatures were killing off the butterfly at the southern extremes of its range, while at the same time allowing it to flourish to the north.
Parmesan said her work on the biogeography of Edith's checkerspot has shown that the level of population extinctions is four times as high at the far southern end of its range (in Mexico) than at the far northern end of its range (in Canada). Extinctions also are about two and one-half times as great at lower elevations as compared to populations above 8,000 ft. This skewed pattern of extinctions is effectively shifting the range of the butterfly both northward by 92 kilometers and upward by 124 meters in elevation.
This distributional shift is of the same magnitude as the temperature increase in western North America over the same time period (temperature isotherms have shifted 105 kilometers north and 105 meters up.)
Because butterflies are very sedentary, each population has evolved very specific adaptations to its local habitat, Parmesan said. These insects only just manage to fit their life cycle into the eight-to 12- week window of time when their host plants are edible.
This window can occur from March to August, depending on the exact locality. Any long-term climate change is likely to affect the length of this window, and either cause the population to do really well (if, for example, caterpillars can have a longer growth period) or go extinct (if, for example, caterpillars have an abbreviated growth period). As a consequence, many experimental studies on sedentary butterfly species indicate that, in general, butterflies are very sensitive to climate changes, Parmesan discovered.
Parmesan's research has focused on multiple aspects of population biology, including the ecology, evolution and behaviors of insect/plant interactions. She has been investigating Edith's
Checkerspot butterfly since 1982. Since that time, she has continued to work, in varying capacities, on both laboratory and field projects centered around the population biology of this butterfly. She also plans to continue working with European butterfly species, investigating the observed range shifts in greater detail. She has been the recipient of a National Science Foundation fellowship as well as a NASA Global Change fellowship.
Parmesan received her B.S. degree in zoology from UT Austin in 1984, and later received her Ph.D. in biological sciences from UT in 1995.