It’s no secret that the modern day education system, particularly in North America, desperately needs to be reformed. Children graduate from high school not understanding how to produce their own food, pay their taxes, or accomplish many everyday, “real world” activities. The education system’s sole purpose should be to educate us in order to better ourselves and society, but instead it just tells us what to think (rather than how to think), so we learn only how to assimilate and blend into society.
Many children graduate not even realizing that the system is broken because they’re so engrained within it. In some cases, they’re even fed propaganda and misinformation. Just take a look in any history textbook: You’d likely see that the Europeans founded North America, completely omitting the mass genocide that took place against Native Americans. Alternatively, if you look into milk education or the Food Guide Pyramid that’s taught to children at a young age in schools, you’d learn that it does not reflect what’s healthy, but rather what’s profitable.
The good news is that this isn’t the case in every country, and some countries are even trying to shift the way we approach education. Finland, a longstanding leader in education, is in the process of completely reforming its education system. Finland will be adopting a “phenomenon-based learning” system, allowing students to drop the standard subjects and experience more holistic, interdisciplinary learning.
What Is Phenomenon-Based Learning?
Phenomenon-based learning takes a very different approach to education, dropping the classic divide amongst subjects like math and science. Instead, students take one particular phenomenon or concept and look at it through multiple lenses, applying it to whatever subjects pertain to it such as geography, history, or economics.
As Phenomenal Education explains on its website:.
So, students would no longer study just one subject like physics, but a whole range of subjects that relate to one topic, taking a more interdisciplinary approach. For example, students could look at the European Union, which could then incorporate languages, economics, history, and geography, and then they could look at climate change the following week, which might involve science, environmental studies, economics, and policy.
The teacher-student relationship will also change fairly dramatically, as students will take a combination of online and in-class courses. The dialogue between students, peers, and teachers will also shift, as students will be encouraged to speak more openly and share information. The structure will be less hierarchical and more of a team-based setting, greatly differing from the classic “teacher instructs student” mentality.
Plus, it won’t be just the teachers and faculty members designing the lesson plans and assessing what students have learned, as the students will play an active role in establishing them. This is great news, as it will hopefully engage students more and shift testing away from focusing only on traditional written exams.
How Finland Will Be Implementing This New Approach
Finland is well-known for being one of the leading countries in education, with incredibly high literacy and numeracy rates. In fact, one of the world’s leading experts on school reform and education, Harvard professor Pasi Sahlberg, has written numerous articles on Finland’s education system. Sahlberg has worked hard to share Finland’s experiences with education reform with the rest of the world, and for good reason.
Finland didn’t always have incredible education statistics, but the country holds a strong appreciation for teaching and learning and has undergone significant educational change. Finland doesn’t use these scores to assess its education system; instead, educators focus on what students need to learn in their lives, not what the exams or rankings say.
The Finnish education system is also decentralized, allowing teachers to alter their lesson plans and arrange schooling according to their local needs and preferences. This greatly differs from the more centralized approach taken in the public education systems in North America.
The Finnish approach to education is already quite innovative, so perhaps that’s why so many teachers are on board with this shift in teaching. In fact, 70% of the teachers in Helsinki are in some way involved in shifting the education system towards phenomenon-based learning.
Some teachers had already started implementing phenomenon-based learning in their classrooms. This isn’t really surprising, as it seems like it would be more rewarding for teachers to be able to connect with students more and teach them what they’d actually like to learn.
Finland plans to gradually change the system, so schools won’t be fully phenomenon-based learning until 2020. The first big change occurred in August 2016 under Finland’s National Curriculum Framework (NCF). The NCF is a binding document that highlights the overall goals of the education system including teaching techniques, learning styles, guidelines, assessments, support services, and more.
The NCF now incorporates phenomenal-based learning and encourages an interdisciplinary approach to teaching. However, this style wasn’t necessarily new to the Finnish, as some teachers have used a more holistic teaching method for quite some time.
As of August, public schools with students aged 7-16 years old need to have one extended period using phenomenon-based learning, the length of which can be determined by the school. Many schools just have two or more periods, each lasting a few weeks, that take this approach.
Why Is This Important?
Many children don’t have a perfect “family life,” so they learn through their experiences outside the home or by themselves. This is why the argument that “children don’t need to be taught practical subjects in school” is so flawed. The education system is supposed to represent the entirety of what we want children — who represent our future — to learn. So why would we be feeding them propaganda and teaching them that there’s only one way to think, one way to feel, and one way to determine intelligence?
There is not one way of determining intellect because we are all unique in our own way. That’s the beauty of duality; our differences are our strengths, and we shouldn’t have to suppress them and conform to society. The public education system should embrace this and teachers should educate their students from the heart and in their own unique way!
That’s why decentralization and phenomenon-based learning could be so useful. It inspires a more collaborative environment and allows students and teachers to connect in a way that division and hierarchy prevents them from doing. Perhaps through this new system, teachers will recognize that they can learn just as much from their students as their students can learn from!