Restoring the Bonds of Affection
Anglican Theological Review, Fall 2005 by Carroll, R William
The Windsor Report would move Anglicanism in the wrong direction. Instead of centralization, which makes colonial, patriarchal, and Constantinian assumptions, I advocate devolving authority. Authority should be dispersed away from bishops and toward the entire people of God, which interprets Scripture with the Spirit's guidance; this is the direction of the subversive character of Jesus' message and the baptismal ecclesiology of the 1979 Prayer Book. The Anglican Communion should be polycentric with self-governing churches discerning God's will in their local context. Indeed, dioceses, parishes, and individuals should be more free to follow their consciences. Authority should be dispersed away from "core doctrines" and toward Jesus, who is the sole center of the Communion. Preserving a Communion held together by "bonds of affection" rather than global hierarchy and canon law would keep Anglicans closer to the gospel, which proclaims Christ alone as Lord.
- Most Popular Articles in Reference
- The importance of understanding organizational culture
- Credit card attitudes and behaviors of college students
- What factors attract foreign direct investment?
- Libraries Need Relationship Marketing - mutual interest marketing concept, ...
- How to set performance goals: employee reviews are more than annual critiques
- More »
Some responses to the Windsor Report have indicated substantial agreement with its doctrinal content, while noting reservations about its practical recommendations. These statements may convey commitment to dialogue, as well as the intention to resist the Report's more extreme proposals. Nevertheless, one should not leave sections A and B unchallenged. These sections make problematic assumptions about authority, subsidiarity, and unity. Although "foundational" claims often turn out to be multivalent,1 no reason exists to allow such premises to stand. A more direct approach makes more room for ecclesiologies that preserve normative Anglicanism's respect for provincial autonomy, summed up in the phrase "bonds of affection."
The problems are interrelated. The Reports conception of authority is insufficiently analogical and fails to acknowledge that true authority, modeled on Jesus and the prophets, subverts unity when unity involves dishonesty or injustice. Furthermore, the Report offers notions of subsidiarity, autonomy, and communion according to which local churches, rather than embodying the church's communion in its fullness, are reduced to mere parts of a whole. Thus, autonomous provinces are not at liberty to discern God's will for themselves. Such innovations are tempting, because the authors believe that only consensus on essentials of teaching and practice can preserve unity.
In what follows, I examine the Report's proposals about authority, subsidiarity, and unity. In each case, I question these proposals and provide alternatives. In general, the Report does too little to challenge a framework inherited from colonial Anglicanism, in which authority is exercised from the "center" outward, and local variation is seen as a matter of indifference or a threat to be neutralized.2 The welcome development that former colonial churches now play more nearly equal roles in the Communion does nothing to change the hegemonic relationship between global and local ecclesial bodies that the Report seeks to create. The kind of centralization represented by the "Anglican Covenant" is not the best recommendation for the future of the Communion. As an alternative, I propose a genuinely polycentric3 and postcolonial Anglicanism, in which intercommunion in Christ enhances rather than diminishes autonomy. Such an approach coheres better with normative Anglicanism. It is also more faithful to gospel-based criticism of power as domination, to insights of Christian feminism, and to requirements for Christian mission in a pluralistic church and world.
Authority: Monologue or Dialogue?
The Report's treatment of authority contains hopeful signs. It disavows any intention to create structures like those in Roman Catholicism (para. 42, 70). It acknowledges the "supreme authority" of Scripture (para. 42). It qualifies this in helpful ways, since ultimate authority resides in "God" and "Jesus, the living Word" (para. 54). The "authority of Scripture" is always "shorthand" for "the authority of the triune God, exercised through scripture" (para. 54). The Report also seems to eschew static, simplistic conceptions of biblical authority (para. 55). In its view, moreover, bishops exercise authority mainly as "teachers," rather than officials within a hierarchy (para. 57-58).
Nevertheless, the Report pays little heed to tensions within the Bible. As Rowan Williams observes, "The meaning of one portion of scriptural text is constructed in opposition to another."4 Scripture contains falsehoods and ideological distortions, and decent theories of interpretation allow for more historical and ideological criticism of the text.5 For example, much that Scripture asserts or implies about the relationships between women and men must be challenged.6 The Report, by contrast, insists that "questions of interpretation are rightly raised, not as an attempt to avoid or relativise scripture and its authority, but as a way of ensuring that it is really scripture that is being heard" (para. 59). It also asserts: "The message of scripture, as a whole and in its several parts, must be preached and taught in all possible and appropriate ways" (para. 58). Does this include the subordination of women and other forms of oppression? Denying that this is part of the essential "message" does not help.7 Portions of Scripture were written and canonized to marginalize women,8 and they are still so used, with deadly results.