I welcome John Long’s response to this in order to keep an important debate going and promise to buy him a coffee/beer of his choice the next time he is in London.
There are two sure ways to lose an argument.
One is the time-honoured: “It’s not what you said, it’s the way you said it.” (Note: it probably is what you said.)
The other, somewhat surprisingly, has reared its head in an opinion piece for The Drum written by John Long – group creative director at Ogilvy & Mather in New York.
In a blog discussing the ubiquity of the word ‘content’, Long tees up why using the word is bad for business as follows:
Pulling out the old dictionary definition card is often a tired trope of awards ceremony acceptance speeches and not a strong footing for a debate.
In essence, Long makes the point that in the first definition of content, the container is the thing that matters – not what’s in it. The second is specifically something that’s written and refers to a whole topic – again, not the actual thing itself. The third states that content is purely a website term, nothing more.
On an etymological level, these summations seem vaguely reasonable. But on any other level, they miss the mark.
What constitutes content?
Long’s examples of content, and therefore why the word is so vague, are quite telling.
He cites a tweet from Arby’s, The Iliad, an Instagram photo of a vape pen and The Godfather. All cuddled together under the content umbrella.
Well, it just isn’t true.
Is a tweet content? Most likely, no. In the business sense (and let’s keep it to strictly a business sense for now), a tweet is there to amplify whatever the actual content is.
Is The Iliad content? Again, I don’t believe it is. I appreciate this is a lighthearted example, but it does show something of a misunderstanding of the term. ‘Content’ is there to inform and engage for the purpose of promoting a brand or product. The Iliad informs and engages, sure, but it would take a cold, hard heart to declare Homer’s epic as a brand-building exercise.
An Instagram photo? See the tweet example. The Godfather? We’re back to The Iliad again.
I take the point. Not everything that is created can be considered of equal value.
But those examples seem to betray a misunderstanding of, not only what content is, but what it’s there to do.
Democratising content
Please allow me to contradict myself:
The internet has democratised the output we produce so that everything is now content.
There, I said it.
Do I believe it? Not really, it’s a sweeping statement lacking in nuance.
But I am more in support of that attitude than the one that sniffs at content as a “website term” and not worthy of being used for short films, for example.
For a start, it’s somewhat puritanical about what is allowed to be called what. Secondly, it reminds me a bit of the time I turned up to cover a conference for a magazine I was writing for. One of the keynote speakers declared: “Social media is the future – we need to get on board”. That was in 2015.
Only recently, a colleague told me of a similar speech at a similar event. The takeaway: “Brands need a website.”
Horses bolting, doors locking etc, etc.
The value of content
“Like a virus, it’s spread – and by definition, it cheapens everything we do,” Long says of content’s overuse/misuse.
Again, I get the point but fundamentally disagree. Bracketing things as content is not what cheapens it – although we should probably agree what content is first of all.
What cheapens content is the same thing that cheapens advertising, or cheapens video production, or cheapens pop music – it’s the bad stuff.
Badly made, offensive or boring content cheapens the form in the same way that brilliantly creative or effective content elevates it. And that’s the same as it ever was.
Take this recent Grand Prix award-winner at the International Content Marketing Awards – created on behalf of the Norwegian Labour Inspection Authority.
It’s a beautiful idea, smartly carried out. It engages, informs, and delivers its message to its audience on behalf of its client – and that’s true whatever you want to call it.
Leave it to the professionals
Ultimately, Long prefers that we “delegate content to stuff amateurs make – the kind that’s ‘user-generated.’”
I couldn’t disagree more.
The concept of content has moved far beyond what Webster’s Dictionary may have outlined. (Let alone the fact that this definition will no doubt be amended in the coming years.)
There are no amateurs when it comes to creating content. There are millions of people who can write more informative articles than me or make snazzier videos, and garner much greater audiences for that content. The fact that I happen to work for a content agency is irrelevant.
The tools to create and distribute are open to all. What differentiates amateur and professional? Whether or not they get paid? Try that argument with the reams of writers, photographers, illustrators and various interns who plug away without a monthly paycheque. The fact that something is user-generated has no bearing on its quality.
We are way beyond the world of amateurs and professionals. All we can do is continue to serve an audience with something interesting, intelligent, useful or entertaining.
Let’s just be content with that.