Most consumers support biometrics for authentication, with voice recognition, facial, and fingerprint scans as their top identity verification methods.
They're also getting frustrated with passwords, with half of them having frequently been unable to conduct an online transaction due to an authentication failure on the website, according to a new survey by The Ponemon Institute and commissioned by Nok Nok Labs. Most of these problems were due to forgotten passwords, usernames, or answers to their preset security questions. Some 60 percent say they would prefer a single, multipurpose identity credential for online and physical access.
But like with most security issues, it's a delicate balance between convenience and actual security: Forty-eight percent don't trust websites or systems that rely solely on passwords, and nearly 40 percent say they don't trust financial service sites that don't require frequent password changes. But they are also tired of password and authentication failures on sites, with less than 50 percent saying authentication failures happen due to problems on the website themselves.
"It seems that people don't have a high degree of trust [with passwords], but they still use" them for online transactions, says Larry Ponemon, chairman and founder of The Ponemon Institute. "And convenience is important: They don't want to remember multiple, complex and long passwords."
The study polled some 1,900 consumers ages 18 to 65 in the U.S., U.K., and Germany, who spent at least 10 hours per week online and conducting online commerce, social networking, and blogging.
Nearly 70 percent of the respondents say that in the past two years they have forgotten one of their passwords because it was too long or complex to retain, and 61 percent were locked out of an online account due to an authentication failure of some sort in the past two years. Some 54 percent of U.S. consumers say it takes too long to reset a password.
"In general, we find folks like multipurpose credentials that would be used for many things because it's more convenient," Ponemon says. "Sixty-three percent would consider or prefer multipurpose credentials."
But the biggest surprise of the survey was how consumers now consider biometrics as an authentication option. Nearly 70 percent of U.S. consumers say biometrics is a viable authentication option. "Five or six years ago, it was no biometrics," says Phillip Dunkelberger, former CEO of PGP and now CEO of startup Nok Nok Labs.
Less than one-third of U.S. and U.K. respondents were against biometrics, with about one-fourth of Germans rejecting the method of authentication. Most support biometrics with "trusted organizations" such as banks, credit card firms, healthcare providers, email providers, or government agencies. Around one-third of consumers in each of the three regions say biometrics would only be acceptable to them if their biometric data was not accessible to the organization they are authenticating to. Voice recognition was by far the most preferred biometric, with 83 to 91 percent of the consumers in favor of it for authentication. Facial scans was next, with 65 to 72 percent of consumers, followed by fingerprints, with 56 to 62 percent of consumers. About half of U.S. and U.K. consumers say iris scanning is acceptable to them, while 66 percent of Germans are in favor of iris scanning biometrics.
The "Moving Beyond Passwords: Consumer Attitudes on Online Authentication"