The Importance of a Brand Rolloutbrodie September 8, 2016
The Washington, DC fire and emergency services department went by the acronym DCFD (District of Columbia Fire Department) for several decades prior to the spring of 2011, when the department rebranded as FEMS (Fire and Emergency Service) to be more inclusive of its medical services. In addition to the name change, a more “playful” blue, yellow and red patch replaced the long-standing golden eagle logo.
This change came as a devastating surprise to the department’s employees, as they felt stripped of the badge that they risked their life for day in and day out. Even more so, these alpha first-responders did not take well to being labeled “FEMS” (ringing eerily similar to ‘effeminate’…)
The department’s rebrand created a collection of very unhappy employees. And, when citizens of DC found out that employees of a life-saving service that they relied on were unhappy, then the citizens too became unhappy. To top it all off, half the department’s uniforms featured the old branding and half the new branding, creating confusion and further diminishing pride in the department’s brand.
So, what do angry employees, worried citizens, and mismatched uniforms have in common? They are all symptoms of not having a proper brand rollout strategy.
At some point or another, every organization will embark on a rebrand or brand refresh. While there are a few staple elements that make for a successful rebrand (ie. proper resources, willingness to embrace change, a rockstar agency to partner with), arguably the most important consideration is having a thoughtful rollout strategy. As Briteweb’s Account Director, I’ve connected with dozens of organizations about to embark on a rebrand. Far too often the focus is almost exclusively on the exercise of rebranding, with no consideration for how it will be rolled out. There are hundreds of steps in a successful rollout strategy, here are a few fundamental considerations.
Treat it like a project
Think of a brand rollout as its own project (because it is!) And, as with any project, you need to establish a budget, develop a timeline and allocate the proper resources. Collaborate with an agency that specializes in branding with a focus on brand rollout and activation strategy. A high level of thought partnership and experience behind this work will yield an exponential return on the investment you’re making in your brand.
The more methodically that you approach the rollout, the more control you will have over the adoption and success of the new brand.
Get internal buy-in and create ambassadors
A common mistake with a rollout is selling the new brand to external stakeholders and audiences while telling internal stakeholders about the new brand. Making sure your staff and internal stakeholders are in support of and engaged with your new brand, is critical to ensuring your customers or external audiences will embrace your new brand as well. When you create excitement among staff, you are creating your most powerful ambassadors. This starts by looping them into the rebrand early on in the process.
Identify critical junctures in the rebranding process (such as discovery, thematic exploration, etc.) where staff input will yield the most value. This input will not only lend an important perspective to the process but when it comes time to unveil the new brand internally, it’s not coming as a shock. Staff will feel as though their voices have been heard and will embrace a sense of pride and ownership in the new brand.
Once the rebranding exercise is complete, internal education to the wider staff that may not have been directly consulted is paramount. Not only do you want to ensure that employees understand the story behind the new brand, but that the use and application of the brand across any medium is clearly defined.
Tell your story and manage public perception
As part of the rebranding exercise, you should have identified your external stakeholders and audience profiles. For each of your stakeholder and audience groups, you will need to develop specific messaging and identify the most effective communication channels to reach them. Chances are, there’s no single communication channel to reach all of your audience groups.
One of the most critical factors here is to avoid leaks! Take the necessary steps to ensure information is locked down until the official reveal. Again, the more you can control the flow of communication, the more influence you will have on the adoption and success of the new brand. You want to be able to tell the brand’s story and elicit specific feelings before the public takes control and tells a story of their own (a big contributor to The Gap’s $100million fail!)
The order and method in which the new brand is delivered can be leveraged to create excitement, gain media attention, and attract new customers. However, done incorrectly (or not at all), you risk causing confusing and isolating external stakeholders and audiences.
Make a list, check it twice
An established brand has a significant number of touchpoints. One example out of a thousand might be, when a donor makes a contribution online, he or she receives your branded ‘thank you’ email, via third party donation platform. For the brand to be most effectively adopted, you want to ensure that there is consistency – this means out with the old in with the new. To do so, you’ll want to elect a person or group to conduct a full audit of the brand’s touchpoints and create a checklist of items that need to be updated with the new identity.
Replacing every piece of brand collateral can be expensive. The time frame in which you replace brand collateral may vary depending on:
- The nature of your organization – Larger organizations and/or organizations with more branded collateral in circulation may choose to stagger the replacements to space out costs.
- The nature of the rebrand – If a rebrand is subtle, an organization may choose to slowly replace collateral. However, more drastic rebrands (name, logo & color changes, etc.) require a more swift collateral replacement, in order to avoid confusing your audience.
Just remember: while you may choose to space it out for budget’s sake, the faster the old brand disappears, the faster people will adopt the new brand.
Maintain, maintain, maintain!
Once the core phases of a rollout are complete, it’s essential that you establish a maintenance plan to ensure the long-term success of your brand. We’ve seen organizations invest in great brand strategies, then only a few months down the road their communications are nearly void of the brand’s distinct identity. These are lost opportunities for an organization to build trust, recognition, and loyalty with its audience.
Just as you would have a digital agency update and maintain your website after its launch, have your branding agency monitor the new brand for 6-12 months after it has been rolled out. The agency will establish goals and metrics to measure areas such as communications, collateral application, and audience perception.
Your brand is a living, breathing entity – the more you nurture it, the greater results it will yield.
Photo by Mili Vigerova