Chemical Process Simulation for Waste Reduction: WAR Algorithm
Description
In traditional chemical process design, attention is focused primarily upon minimizing cost, while the environmental impact of a process is often overlooked. This may in many instances lead to the production of large quantities of waste materials. It is possible to reduce the generation of these wastes and their environmental impact by modifying the design of the process. However, the design methodologies for waste minimization do not exist, and, thus, research activities have been underway at EPA's National Risk Management Research Laboratory to develop such methodologies.
The method is based on a potential environmental impact (PEI) balance for chemical processes. The PEI is a relative measure of the potential for a chemical to have an adverse effect on human health and the environment (e.g., aquatic ecotoxicolgy, global warming, etc.). The result of the PEI balance is an impact (pollution) index that provides a quantitative measure of the impact of the waste generated in the process. The goal of this methodology is to minimize the PEI for a process instead of minimizing the amount of waste (pollutants) generated by a process. We have, therefore, developed an algorithm for estimating the human health and environmental impact of chemicals by adapting the results of several studies from EPA and other sources. The impact estimation algorithm is sophisticated and flexible enough to allow users to emphasize or deemphasize different hazards as needed for particular applications. For example, an operation in an area suffering from smog might emphasize air pollution effects, while an operation where workers are routinely exposed to chemicals might emphasize human health effects. In using our methodology for process design, a process simulator is used to construct and calculate the material and energy balance, and then determine the impact indexes. Next, impact-reducing changes are made to the process design, and the mass and energy balances and the impact indexes are recalculated. This process is repeated until an economically and environmentally acceptable process design is obtained. The result is a robust process design that integrally incorporates environmental impact reduction.
Status
The mathematical basis of the waste reduction (WAR) algorithm, including the chemical impact estimation, has been established; the database of chemical environmental impacts has been created; and a computer algorithm for incorporating the WAR methodology into process simulators has been developed. The first version of the WAR algorithm has been integrated into the commercial simulator ChemCAD IV under a Cooperative Research and Development Agreement (CRADA) between EPA and Chemstations, Inc. A number of other CRADAs are being negotiated that involve the further development of the WAR algorithm.
Estimated Completion Date
The first version has been completed.
Download WAR Software
The database in the WAR software is updated yearly. Get e-mail alerts when new versions of the WAR software are posted.
Download the software (version 1.0.17) and then follow the installation instructions provided below. In version 1.0.17, the chemical database has been updated and a few small bugs have been corrected. The software was last updated on June 3, 2008.
Download Instructions
- Save the install.exe file to your hard drive. Due to the large size of the file, the download may take 15 minutes or longer, depending on the speed of the connection.
- Once the file is saved on your hard drive, exit all open programs on your computer.
- Then, double click on the install.exe file.
- In some cases, the computer may need to be rebooted in order to complete the installation process. Afterwards, the WAR Algorithm icon will appear on your desktop.
- Double-click the icon to start the program.
Available Publications
Environmental Optimization Using the WAste Reduction Algorithm (WAR) – August 2011
Fu, Y., U.M. Diwekar, D.M. Young and H. Cabezas. (2001). “Designing Processes for Environmental Problems.” Chapter 12 in Process Design Tools for the Environment, Edited by S.K. Sikdar and M. El-Halwagi. Taylor and Francis, New York, NY. p. 295–318.
Fu, Y., U.M. Diwekar, D.M. Young and H. Cabezas. (2000). “Process Design for the Environment: A Multi-Objective Framework Under Uncertainty.” Clean Products and Processes, 2, 2: 92–107.
Young, D.M. and H. Cabezas. (2000). “The Waste Reduction (WAR) Algorithm: Environmental Impacts, Energy Consumption, and Engineering Economics.” Waste Management, 20, 8: 605–615.
Young, D.M. and H. Cabezas. (1999). “Designing Sustainable Processes with Simulation: The Waste Reduction (WAR) Algorithm.” Computers & Chemical Engineering, 23, 10: 1477–1491.
Cabezas, H., J.C. Bare and S.K. Mallick. (1999). “Pollution Prevention with Chemical Process Simulators: The Generalized Waste Reduction (WAR) Algorithm - Full Version.” Computers & Chemical Engineering, 23, 4–5: 623–634.
Hilaly, A.K., S.K. Sikdar, H. Cabezas, S.K. Mallick and J. C. Bare. (1998). “Waste Reduction Using Computer-Aided Design Tools.” Encyclopedia of Chemical Processing and Design, Vol. 65, p. 97–119.
Cabezas, H., J.C. Bare and S.K. Mallick. (1997). “Pollution Prevention with Chemical Process Simulators: The Generalized Waste Reduction (WAR) Algorithm.” Computers & Chemical Engineering, 21, 1: S305–S310.
Mallick, S.K., H. Cabezas, J.C. Bare and S.K. Sikdar. (1996). “A Pollution Reduction Methodology for Chemical Process Simulators.” Industrial & Engineering Chemistry Research, 35, 11: 4128–4138.
See Also
CAPE-OPEN Computer Aided Process Engineering