Standard & Poor’s downgrades the United States, signifying the country’s debt is riskier. Investors, instead of demanding higher interest rates, stampede into Treasuries, driving their price up and yields down. They sell stocks en masse, sending their prices down and blue-chip dividend yields up – with many significantly higher than what the Treasuries are paying.
I’m not sure that this was how it was explained in my economics textbook. But these aren’t exactly textbook times.
A number of analysts had predicted this rather counterintuitive result, as they figured, correctly, that general economic fears, coupled with the headline shock from the ratings action, would cause investors to become more fearful of stocks and seek Treasuries as a safe haven, regardless of what S&P thought.
No matter: Without dwelling too much on the macroeconomics, let’s look at the opportunity for investors. More than 200 stocks in the S&P 500 have a dividend yield higher than the 10-year Treasury, which sold at auction Wednesday afternoon at a record-low 2.14 per cent.
This actually understates the matter, as 110 companies in the S&P 500 pay no dividends at all. So roughly 60 per cent of the dividend-paying companies in the index are out-yielding 10-year Treasuries. (All of the data is from Standard & Poor’s Capital IQ database.)
Some, to be fair, look unsustainable, with yields in the high single digits or above. But the vast majority are recognizable names with good cash flow, healthy balance sheets and solid business prospects. And their yields don’t just creep by Treasuries by a hair – in many cases, their yields are double or more.
AT&T Inc. and Verizon Communications Inc. , the two largest U.S. phone companies, are yielding around 6 per cent. Health-care giants Merck & Co. Inc., Pfizer Inc. and Eli Lilly & Co. (of which I own 100 shares) yield between 4.5 and 5.5 per cent per cent. A host of utilities, long known as good dividend payers, have seen their yields pushed to 5 per cent or more.
And investors need not pay up for the privilege: About two-thirds of these high-yielding companies are selling for less than 15 times trailing earnings. More than three dozen trade for a trailing price-to-earnings ratio of less than 10, including Exxon Mobil and ConocoPhillips; the aforementioned AT&T and Eli Lilly; agri-giant Archer Daniels Midland Co. ; and Freeport-McMoRan Copper & Gold Inc.
Now, let’s be clear about the risks. The recent pathetic U.S. gross domestic product numbers, coupled with the underwhelming denouement of the country’s budget battle, have given investors good reasons to be pessimistic. Although there are fundamental differences between 2008 and now, no one can say that stocks won’t slide another 10 or 20 per cent, or more.
And yet no one can say with certainty that they will, either. There are at least a couple things we know, though.
One is that the power of compounding is massively blunted when you’re earning 2 per cent per year. If you want $500,000 in 20 years, you need to start with $155,902 today if you’re earning 6 per cent a year. You need $336,486 today if you’re earning 2 per cent each year.
The other is that price appreciation in bonds is severely limited when they’re trading at record highs. Stocks have no such mathematical limitation.
This, then, is the high price of safety in today’s fearful market. Hundreds of stocks offer better yields than Treasuries, plus the prospect of capital appreciation. Bonds offer an annual return that may not best inflation over the medium term – and certainly slows your pace toward accumulating a retirement nest egg.
I am more than 20 years from retirement – perhaps 30 or more. So I employed this strategy Monday afternoon, putting about $35,000 (U.S.), roughly half of one of my retirement accounts, into these high-dividend S&P members.
Fearing another drop in equities, you may be telling yourself you can’t afford the risk of buying stocks. If your time horizon is 10 years or more, you probably can’t afford not to.
______
Just a few of the S&P 500 stocks with a price-to-earnings ratio below 10 and a dividend yield more than the 10-year Treasury:
AT&T Inc. Price-to-earnings: 8.1/ Yield: 6.2%
International Paper Inc. Price-to-earnings: 8.2/Yield: 4.5%
JPMorgan Chase & Co. Price-to-earnings: 7.3/ Yield: 2.9%
Raytheon Co. Price-to-earnings: 7.2/Yield: 4.4%
Gap Inc. Price-to-earnings: 8.5/ Yield 2.9%